/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.spill;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.store.impl.RowConvert;
import kd.bos.algo.dataset.store.spill.LazyMemorySegmentSource;
import kd.bos.algo.dataset.store.spill.MemIO;
import kd.bos.algo.dataset.store.spill.MemIOFactory;
import kd.bos.algo.dataset.store.spill.SpillingOutputView;
import kd.bos.algox.RowX;
import kd.bos.algox.flink.type.RowXTypeInfo;
import kd.bos.algox.flink.type.TypeUtil;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.io.disk.iomanager.ChannelReaderInputView;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.util.MutableObjectIterator;

public class SpillingWriter
implements Iterable<RowX> {
    protected final TypeSerializer<RowX> serializer;
    private int elementCount;
    protected final SpillingOutputView buffer;
    protected final MemoryManager memoryManager;
    LazyMemorySegmentSource memSource;
    private final RowMeta rowMeta;
    private AbstractInvokable parentTask;
    private LinkedList<InputViewIterator> iterators = new LinkedList();

    public SpillingWriter(RowMeta rowMeta, MemoryManager memoryManager, IOManager ioManager, int numPages, AbstractInvokable parentTask) {
        this.rowMeta = rowMeta;
        this.parentTask = parentTask;
        try {
            this.memoryManager = memoryManager;
            this.memSource = new LazyMemorySegmentSource(parentTask, memoryManager, numPages);
            this.buffer = new SpillingOutputView(ioManager, this.memSource, memoryManager.getPageSize());
            RowXTypeInfo typeInfo = TypeUtil.toRowXType(rowMeta);
            this.serializer = typeInfo.createSerializer(rowMeta);
        }
        catch (Exception e) {
            try {
                this.memSource.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AlgoException(e);
        }
    }

    public void writeRowXIter(Iterator<RowX> iter) {
        try {
            while (iter.hasNext()) {
                this.serializer.serialize((Object)iter.next(), (DataOutputView)this.buffer);
                ++this.elementCount;
            }
        }
        catch (Exception e) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new AlgoException(e);
        }
    }

    public void writeRowIter(Iterator<Row> iter) {
        this.writeRowXIter(RowConvert.toRowXIterator(this.rowMeta, iter));
    }

    public void writeRow(Row row) {
        RowX rowX = RowConvert.toRowX(this.rowMeta, row);
        try {
            this.serializer.serialize((Object)rowX, (DataOutputView)this.buffer);
            ++this.elementCount;
        }
        catch (Exception e) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new AlgoException(e);
        }
    }

    public void writeRowXIter(MutableObjectIterator<RowX> iter) {
        try {
            RowX rowX;
            while ((rowX = (RowX)iter.next()) != null) {
                this.serializer.serialize((Object)rowX, (DataOutputView)this.buffer);
                ++this.elementCount;
            }
        }
        catch (Exception e) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new AlgoException(e);
        }
    }

    private LazyMemorySegmentSource getMemSourceForInputView() {
        MemIO memIO = MemIOFactory.createForSpillBuffer();
        return new LazyMemorySegmentSource(this.parentTask, memIO.getMemoryManager(), memIO.getMemoryManager().getTotalNumPages());
    }

    @Override
    public Iterator<RowX> iterator() {
        DataInputView inView;
        InputViewIterator iter2;
        boolean allClosed = true;
        for (InputViewIterator iter2 : this.iterators) {
            if (iter2.isClosed()) continue;
            allClosed = false;
            break;
        }
        try {
            inView = allClosed ? this.buffer.getView() : this.buffer.getViewNew(this.getMemSourceForInputView());
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new AlgoException(e);
        }
        iter2 = new InputViewIterator(inView);
        this.iterators.add(iter2);
        return iter2;
    }

    public int size() {
        return this.elementCount;
    }

    public void close() {
        this.memSource.close();
        for (InputViewIterator iter : this.iterators) {
            iter.closeInView();
        }
        try {
            this.buffer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class InputViewIterator
    implements Iterator<RowX> {
        private boolean inViewClosed;
        private int pos;
        private DataInputView inView;

        public InputViewIterator(DataInputView inView) {
            this.inView = inView;
        }

        @Override
        public boolean hasNext() {
            boolean b;
            boolean bl = b = this.pos < SpillingWriter.this.elementCount;
            if (!b) {
                this.closeInView();
            }
            return b;
        }

        @Override
        public RowX next() {
            if (this.pos >= SpillingWriter.this.elementCount) {
                this.closeInView();
                throw new NoSuchElementException();
            }
            try {
                RowX rowX = (RowX)SpillingWriter.this.serializer.deserialize(this.inView);
                ++this.pos;
                return rowX;
            }
            catch (IOException e) {
                try {
                    this.closeInView();
                    SpillingWriter.this.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new AlgoException(e);
            }
        }

        public boolean isClosed() {
            return this.inViewClosed;
        }

        private void closeInView() {
            if (this.inViewClosed) {
                return;
            }
            this.inViewClosed = true;
            if (this.inView instanceof ChannelReaderInputView) {
                try {
                    ((ChannelReaderInputView)this.inView).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

