/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.env;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.env.Environment;
import kd.bos.util.ThreadLocals;
import org.apache.log4j.Logger;

public class ThreadContext
implements Closeable,
AutoCloseable {
    private static Logger logger = Logger.getLogger(ThreadContext.class);
    private static ThreadLocal<ThreadContext> tlContext = ThreadLocals.create(() -> new ThreadContext());
    private static boolean autoReleaseWhenThreadDie = true;
    private HashMap<String, Environment> envMap = new HashMap();
    private ArrayList<Closeable> allCloseable = new ArrayList();

    public void addEnv(Environment env) {
        this.envMap.put(env.getConfig().getKey(), env);
    }

    private void removeEnv(Environment env) {
        this.envMap.remove(env.getConfig().getKey());
    }

    @Override
    public void close() {
        if (autoReleaseWhenThreadDie) {
            ArrayList<Environment> list = new ArrayList<Environment>(this.envMap.size());
            list.addAll(this.envMap.values());
            for (Environment env : list) {
                try {
                    env.close();
                }
                catch (Throwable e) {
                    logger.error((Object)e);
                }
            }
            this.envMap.clear();
            ArrayList<Closeable> toRemove = new ArrayList<Closeable>();
            toRemove.addAll(this.allCloseable);
            for (Closeable c : toRemove) {
                try {
                    c.close();
                }
                catch (Throwable e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    public Environment getEnv(String key) {
        return this.envMap.get(key);
    }

    public void addStore(Store store) {
        this.allCloseable.add(store);
    }

    public void removeStore(Store store) {
        this.allCloseable.remove(store);
    }

    public static ThreadContext getCurrent() {
        return tlContext.get();
    }

    public static void addEnvironment(Environment env) {
        tlContext.get().addEnv(env);
    }

    public static void removeEnvironment(Environment env) {
        tlContext.get().removeEnv(env);
    }

    public static void clear() {
        tlContext.get().close();
        tlContext.remove();
    }

    static {
        String str = System.getProperty("algo.autoCloseDataSet");
        if (str != null) {
            autoReleaseWhenThreadDie = Boolean.parseBoolean(str);
        }
    }
}

