/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.serde;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.RowFactory;
import kd.bos.algo.serde.RowSerde;

public class JavaRowSerde
extends RowSerde {
    @Override
    public void write(RowMeta rowMeta, Row row, DataOutputStream out) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(out);
            int size = rowMeta.getFieldCount();
            for (int i = 0; i < size; ++i) {
                oos.writeObject(row.get(i));
            }
            oos.flush();
        }
        catch (Exception e) {
            throw new AlgoException("algo serialize row error.", e);
        }
    }

    @Override
    public Row read(RowMeta rowMeta, DataInputStream in) {
        try {
            ObjectInputStream oin = new ObjectInputStream(in);
            int size = rowMeta.getFieldCount();
            Object[] values = new Object[size];
            for (int i = 0; i < size; ++i) {
                values[i] = oin.readObject();
            }
            return RowFactory.createRow(rowMeta, values, false);
        }
        catch (Exception e) {
            throw new AlgoException("algo deserialize row error.", e);
        }
    }
}

