/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.parser;

import kd.bos.algo.AlgoException;
import kd.bos.algo.sql.Parser;
import kd.bos.algo.sql.g.GLexer;
import kd.bos.algo.sql.g.GParser;
import kd.bos.algo.sql.parser.ASTBuilder;
import kd.bos.algo.sql.parser.NoCaseStringStream;
import kd.bos.algo.sql.parser.ParseError;
import kd.bos.algo.sql.parser.ParseErrorListener;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.Statement;
import kd.bos.algo.util.AlgoSystemInit;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;

public class SqlParser
extends Parser {
    ParseErrorListener errorListener = new ParseErrorListener();

    @Override
    public Expr parseExpr(String expr) {
        try {
            GParser parser = this.parse(expr);
            ASTBuilder visitor = new ASTBuilder(expr);
            Expr result = (Expr)visitor.visitSingleExpression(parser.singleExpression());
            return result;
        }
        catch (ParseError e) {
            throw new AlgoException("Parser '" + expr + "' error:" + e.getMsg());
        }
        catch (Throwable e) {
            throw new AlgoException("Parser '" + expr + "' error:" + e.getMessage(), e);
        }
    }

    public Statement parseStatement(String sql) {
        try {
            GParser parser = this.parse(sql);
            ASTBuilder visitor = new ASTBuilder(sql);
            Statement result = (Statement)visitor.visitQuery(parser.query());
            return result;
        }
        catch (ParseError e) {
            throw new AlgoException("Parser '" + sql + "' error:" + e.getMsg());
        }
        catch (Throwable e) {
            throw new AlgoException("Parser '" + sql + "' error:" + e.getMessage(), e);
        }
    }

    @Override
    public Expr parseSortList(String expr) {
        GParser parser = this.parse(expr);
        ASTBuilder visitor = new ASTBuilder(expr);
        Expr result = (Expr)visitor.visitSortSet(parser.sortSet());
        return result;
    }

    private GParser parse(String sql) {
        GLexer lexer = new GLexer((CharStream)new NoCaseStringStream(sql));
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)this.errorListener);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        GParser parser = new GParser((TokenStream)tokenStream);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)this.errorListener);
        try {
            try {
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
                return parser;
            }
            catch (ParseCancellationException e) {
                tokenStream.reset();
                parser.reset();
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
                return parser;
            }
        }
        catch (ParseError e) {
            e.printStackTrace();
            throw new AlgoException(String.format("Parse error for %s, at line %d:%d, because %s.", sql, e.getLine(), e.getCharPositionInLine(), e.getMsg()));
        }
        catch (Exception e) {
            throw new AlgoException("Error parse " + sql, e);
        }
    }

    static {
        AlgoSystemInit.init();
    }
}

