/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.schema;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.List;
import kd.bos.algo.sql.tree.QualifiedName;

public class QualifiedObjectName {
    private final String schemaName;
    private final String objectName;

    public QualifiedObjectName(String schemaName, String objectName) {
        this.schemaName = schemaName;
        this.objectName = objectName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public static QualifiedObjectName valueOf(String name) {
        ImmutableList ids = ImmutableList.copyOf((Iterable)Splitter.on((char)'.').split((CharSequence)name));
        Preconditions.checkArgument((ids.size() <= 2 ? 1 : 0) != 0, (String)"Invalid name %s", (Object)name);
        if (ids.size() == 1) {
            return new QualifiedObjectName(null, (String)ids.get(0));
        }
        return new QualifiedObjectName((String)ids.get(0), (String)ids.get(1));
    }

    public static QualifiedObjectName valueOf(QualifiedName name) {
        List<String> ids = name.getParts();
        Preconditions.checkArgument((ids.size() <= 2 ? 1 : 0) != 0, (String)"Invalid name %s", (Object)name);
        if (ids.size() == 1) {
            return new QualifiedObjectName(null, ids.get(0));
        }
        return new QualifiedObjectName(ids.get(0), ids.get(1));
    }
}

