/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import java.util.Optional;
import kd.bos.algo.DataType;
import kd.bos.algo.datatype.AnyType;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.CaseWhenClause;
import kd.bos.algo.sql.tree.CaseWhenTypes;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CaseWhenSearchCalc;
import kd.bos.algo.sql.tree.calc.CaseWhenSearchWithElseCalc;
import kd.bos.algo.sql.tree.calc.CompileContext;

public class CaseWhenSearch
extends Expr {
    private DataType dataType;
    boolean hasElse;
    private CaseWhenClause[] whenClauses;

    public CaseWhenSearch(Optional<NodeLocation> location, CaseWhenClause[] whenClauses) {
        super(location, whenClauses, CaseWhenSearch.repeatDataTypes(AnyType.instance, whenClauses.length));
        this.whenClauses = whenClauses;
    }

    public CaseWhenSearch(Optional<NodeLocation> location, CaseWhenClause[] whenClauses, Expr elseExpr) {
        super(location, CaseWhenSearch.concatExprs(whenClauses, elseExpr), CaseWhenSearch.repeatDataTypes(AnyType.instance, whenClauses.length + 1));
        this.whenClauses = whenClauses;
        this.hasElse = true;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCaseWhenSearch(this, context);
    }

    @Override
    public DataType getDataType() {
        if (this.dataType == null) {
            this.dataType = CaseWhenTypes.guessDataType(this, this.whenClauses, this.hasElse);
        }
        return this.dataType;
    }

    @Override
    public String sql() {
        String sql = "CASE ";
        int length = this.hasElse ? this.children.length - 1 : this.children.length;
        for (int i = 0; i < length; ++i) {
            sql = sql + " " + this.children[i].sql();
        }
        if (this.hasElse) {
            sql = sql + " ELSE " + this.children[this.children.length - 1].sql();
        }
        sql = sql + " END";
        return sql;
    }

    public boolean hasElse() {
        return this.hasElse;
    }

    @Override
    public Calc compile(CompileContext context) {
        int length = this.hasElse ? this.children.length - 1 : this.children.length;
        Calc[] conditionCalcs = new Calc[length];
        Calc[] resultCalcs = new Calc[length];
        for (int i = 0; i < length; ++i) {
            CaseWhenClause clause = (CaseWhenClause)this.children[i];
            conditionCalcs[i] = clause.getConditionExpr().compile(context);
            resultCalcs[i] = clause.getResultExpr().compile(context);
        }
        if (this.hasElse) {
            Calc elseCalc = this.children[this.children.length - 1].compile(context);
            return new CaseWhenSearchWithElseCalc(conditionCalcs, resultCalcs, elseCalc);
        }
        return new CaseWhenSearchCalc(conditionCalcs, resultCalcs);
    }
}

