/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Optional;
import kd.bos.algo.DataType;
import kd.bos.algo.datatype.AnyType;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CompileContext;
import kd.bos.algo.sql.tree.calc.InCalc;
import kd.bos.algo.util.AlgoUtil;

public class In
extends Expr {
    public In(Optional<NodeLocation> location, Expr value, Expr[] list) {
        super(location, In.concatExprs(value, list), In.repeatDataTypes(AnyType.instance, list.length + 1));
    }

    @Override
    public String sql() {
        StringBuilder listSql = new StringBuilder();
        for (int i = 1; i < this.children.length; ++i) {
            if (i > 1) {
                listSql.append(",");
            }
            listSql.append(this.children[i].sql());
        }
        return this.children[0].sql() + " IN (" + listSql + ")";
    }

    private boolean inArray(Object v, Object array) {
        int len = Array.getLength(array);
        for (int i = 0; i < len; ++i) {
            Object o = Array.get(array, i);
            if (!AlgoUtil.equal(v, o)) continue;
            return true;
        }
        return false;
    }

    private boolean inCollection(Object v, Collection<Object> set) {
        for (Object o : set) {
            if (!AlgoUtil.equal(v, o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DataType getDataType() {
        return DataType.BooleanType;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIn(this, context);
    }

    @Override
    public Calc compile(CompileContext context) {
        return new InCalc(this.compileChildren(context));
    }
}

