/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import java.util.Optional;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.datatype.AnyType;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.UnaryExpr;
import kd.bos.algo.sql.tree.UnresolvedAttribute;
import kd.bos.algo.sql.tree.bind.ColumnRef;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CompileContext;
import kd.bos.algo.sql.tree.calc.RightColumnCalc;

public class PreRowValueExpr
extends UnaryExpr {
    public static final String KEY = "$PreRowValue$";

    public PreRowValueExpr(Expr child, DataType inputType) {
        this(Optional.empty(), child, inputType);
    }

    public PreRowValueExpr(Optional<NodeLocation> location, Expr child, DataType inputType) {
        super(location, child, inputType);
    }

    @Override
    public DataType getDataType() {
        if (this.getChild() instanceof UnresolvedAttribute) {
            return AnyType.instance;
        }
        return this.getChild().getDataType();
    }

    @Override
    public String sql() {
        return "PreRowValue(" + this.getChild().sql() + ")";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return null;
    }

    @Override
    public Calc compile(CompileContext context) {
        String name;
        Expr child = this.getChild();
        if (child instanceof ColumnRef) {
            name = ((ColumnRef)child).getName();
        } else if (child instanceof UnresolvedAttribute) {
            name = ((UnresolvedAttribute)child).sql();
        } else {
            throw new AlgoException("Not support PreRowValue(" + child.toString() + ")");
        }
        int index = context.rowMeta2.getFieldIndex(name);
        return new RightColumnCalc(index);
    }
}

