/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.Node;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.SelectItem;

public class Select
extends Node {
    private final boolean distinct;
    private List<SelectItem> selectItems;

    public Select(boolean distinct, List<SelectItem> selectItems) {
        this(Optional.empty(), distinct, selectItems);
    }

    public Select(NodeLocation location, boolean distinct, List<SelectItem> selectItems) {
        this(Optional.of(location), distinct, selectItems);
    }

    public Select(Optional<NodeLocation> location, boolean distinct, List<SelectItem> selectItems) {
        super(location);
        this.distinct = distinct;
        this.selectItems = ImmutableList.copyOf((Collection)Objects.requireNonNull(selectItems, "selectItems"));
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public List<SelectItem> getSelectItems() {
        return this.selectItems;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSelect(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.copyOf(this.selectItems);
    }

    @Override
    public void replaceChild(int index, Node node) {
        this.selectItems.set(index, (SelectItem)node);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("distinct", this.distinct).add("selectItems", this.selectItems).omitNullValues().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Select select = (Select)o;
        return this.distinct == select.distinct && Objects.equals(this.selectItems, select.selectItems);
    }

    public int hashCode() {
        return Objects.hash(this.distinct, this.selectItems);
    }
}

