/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.Node;
import kd.bos.algo.sql.tree.NodeLocation;

public class SortItem
extends Node {
    private Expr sortKey;
    private final Ordering ordering;

    public SortItem(Expr sortKey, Ordering ordering) {
        this(Optional.empty(), sortKey, ordering);
    }

    public SortItem(NodeLocation location, Expr sortKey, Ordering ordering) {
        this(Optional.of(location), sortKey, ordering);
    }

    public SortItem(Optional<NodeLocation> location, Expr sortKey, Ordering ordering) {
        super(location);
        this.ordering = ordering;
        this.sortKey = sortKey;
    }

    public Expr getSortKey() {
        return this.sortKey;
    }

    public Ordering getOrdering() {
        return this.ordering;
    }

    public String sql() {
        return this.sortKey.toString() + " " + (this.ordering == Ordering.ASCENDING ? "asc" : "desc");
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSortItem(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.sortKey);
    }

    @Override
    public void replaceChild(int index, Node node) {
        this.sortKey = (Expr)node;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sortKey", (Object)this.sortKey).add("ordering", (Object)this.ordering).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortItem sortItem = (SortItem)o;
        return Objects.equals(this.sortKey, sortItem.sortKey) && this.ordering == sortItem.ordering;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sortKey, this.ordering});
    }

    public static enum NullOrdering {
        FIRST,
        LAST,
        UNDEFINED;

    }

    public static enum Ordering {
        ASCENDING,
        DESCENDING;

    }
}

