/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.algo.sql.tree.AstVisitor;
import kd.bos.algo.sql.tree.Node;
import kd.bos.algo.sql.tree.NodeLocation;
import kd.bos.algo.sql.tree.Relation;
import kd.bos.algo.sql.tree.SetOperation;

public class Union
extends SetOperation {
    private final List<Relation> relations;

    public Union(List<Relation> relations, boolean distinct) {
        this(Optional.empty(), relations, distinct);
    }

    public Union(NodeLocation location, List<Relation> relations, boolean distinct) {
        this(Optional.of(location), relations, distinct);
    }

    public Union(Optional<NodeLocation> location, List<Relation> relations, boolean distinct) {
        super(location, distinct);
        Objects.requireNonNull(relations, "relations is null");
        this.relations = ImmutableList.copyOf(relations);
    }

    @Override
    public List<Relation> getRelations() {
        return this.relations;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitUnion(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.copyOf(this.relations);
    }

    @Override
    public void replaceChild(int index, Node node) {
        this.relations.set(index, (Relation)node);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("relations", this.relations).add("distinct", this.isDistinct()).toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Union o = (Union)obj;
        return Objects.equals(this.relations, o.relations) && Objects.equals(this.isDistinct(), o.isDistinct());
    }

    public int hashCode() {
        return Objects.hash(this.relations, this.isDistinct());
    }
}

