/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree.calc;

import java.math.BigDecimal;
import kd.bos.algo.RowFeature;
import kd.bos.algo.sql.tree.calc.Calc;

public final class AbsCalc
implements Calc {
    private Calc child;

    public AbsCalc(Calc child) {
        this.child = child;
    }

    @Override
    public Object execute(RowFeature row1, RowFeature row2) {
        Object value = this.child.execute(row1, row2);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            Math.abs((Integer)value);
        }
        if (value instanceof Long) {
            return Math.abs((Long)value);
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).abs();
        }
        if (value instanceof Double) {
            return Math.abs((Double)value);
        }
        if (value instanceof Float) {
            return Float.valueOf(Math.abs(((Float)value).floatValue()));
        }
        throw new IllegalArgumentException("Number value required, but found " + value + " of " + value.getClass().getName());
    }
}

