/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree.calc;

import java.math.BigDecimal;
import kd.bos.algo.AlgoException;
import kd.bos.algo.RowFeature;
import kd.bos.algo.sql.interpret.ExplicitCheck;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.util.AlgoUtil;

public final class RemainderCalc
implements Calc {
    private Calc calc1;
    private Calc calc2;

    public RemainderCalc(Calc calc1, Calc calc2) {
        this.calc1 = calc1;
        this.calc2 = calc2;
    }

    @Override
    public Object execute(RowFeature row1, RowFeature row2) {
        Number right = ExplicitCheck.checkNumber(this.calc2.execute(row1, row2), "% only apply to number, but %s found ");
        if (right == null) {
            return null;
        }
        Number left = ExplicitCheck.checkNumber(this.calc1.execute(row1, row2), "% only apply to number, but %s found ");
        if (left == null) {
            return right;
        }
        if (left instanceof Integer) {
            if (right instanceof Integer) {
                return (Integer)left % (Integer)right;
            }
            return AlgoUtil.toBigDecimal(left).remainder(AlgoUtil.toBigDecimal(right));
        }
        if (left instanceof Long) {
            if (right instanceof Long) {
                return (Long)left % (Long)right;
            }
            return AlgoUtil.toBigDecimal(left).remainder(AlgoUtil.toBigDecimal(right));
        }
        if (left instanceof Double) {
            return (Double)left % Double.valueOf(right.toString());
        }
        if (left instanceof BigDecimal) {
            return AlgoUtil.toBigDecimal(left).remainder(AlgoUtil.toBigDecimal(right));
        }
        throw new AlgoException("Remainder eval TODO");
    }
}

