/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.sql.tree.func.calc;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.RowFeature;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.ExprParser;
import kd.bos.formula.excel.FunDef;

public class FormulaCalc
implements Calc {
    private Calc[] children;
    private String[] argNames;
    private Expr formulaExpr;
    Map<String, Object> params;

    public FormulaCalc(Calc[] children, String name, DataType resultType) {
        this.children = children;
        FunDef ff = FunDef.getFunDef((String)name);
        if (ff == null) {
            throw new AlgoException("Function '%s' not found.", name);
        }
        String formula = name + "(";
        if (children != null) {
            this.argNames = new String[children.length];
            for (int i = 0; i < children.length; ++i) {
                String key;
                this.argNames[i] = key = "arg__" + i;
                formula = formula + key;
                if (i >= children.length - 1) continue;
                formula = formula + ",";
            }
            this.params = new HashMap<String, Object>(children.length);
        }
        formula = formula + ")";
        this.formulaExpr = ExprParser.parse((String)formula);
    }

    @Override
    public Object execute(RowFeature row1, RowFeature row2) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.params.put(this.argNames[i], this.children[i].execute(row1, row2));
            }
            return FormulaEngine.execExcelFormula((Expr)this.formulaExpr, this.params);
        }
        return FormulaEngine.execExcelFormula((Expr)this.formulaExpr);
    }
}

