/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.storage;

import java.util.concurrent.ConcurrentHashMap;
import kd.bos.algo.AlgoException;
import kd.bos.algo.storage.FileSystemStorage;
import kd.bos.algo.storage.KVStorage;
import kd.bos.algo.storage.local.LocalStorage;

public class StorageFactory {
    protected static String DEFAULTKEY = "algo.storage";
    protected static String ConfigKeyPrefix = "algo.storage.";
    private static ConcurrentHashMap<String, FileSystemStorage> file_instances = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, KVStorage> kv_instances = new ConcurrentHashMap();

    public static FileSystemStorage getFileSystemStorage() {
        return StorageFactory.getAlluxioStorage();
    }

    public static FileSystemStorage getLocalFileSystemStorage() {
        return StorageFactory.getLocalStorage();
    }

    public static KVStorage getKVStorage() {
        return StorageFactory.getRedisStorage();
    }

    public static KVStorage getKVHbaseStorage() {
        return StorageFactory.getHbaseStorage();
    }

    public static KVStorage getKVCephStorage() {
        return StorageFactory.getCephStorage();
    }

    public static FileSystemStorage get(String configKey) {
        String v;
        if (configKey == null) {
            configKey = DEFAULTKEY;
        }
        if ((v = System.getProperty(configKey)) == null) {
            v = System.getProperty(DEFAULTKEY);
        }
        if (v == null) {
            v = "local";
        }
        return StorageFactory.getStorageByType(v);
    }

    private static FileSystemStorage getStorageByType(String type) {
        String className = System.getProperty(ConfigKeyPrefix + type + ".class");
        if (className != null) {
            FileSystemStorage storage = file_instances.get(className);
            if (storage != null) {
                return storage;
            }
            return StorageFactory.createByClassName(className);
        }
        FileSystemStorage storage = file_instances.get(type);
        if (storage != null) {
            return storage;
        }
        if ("local".equalsIgnoreCase(type)) {
            storage = StorageFactory.getLocalStorage();
        } else if ("alluxio".equalsIgnoreCase(type)) {
            storage = StorageFactory.getAlluxioStorage();
        } else {
            throw new AlgoException("Unsupported storage type:" + type);
        }
        file_instances.put(type, storage);
        return storage;
    }

    private static FileSystemStorage getAlluxioStorage() {
        return StorageFactory.createByClassName("kd.bos.algo.storage.alluxio.AlluxioStorage");
    }

    private static KVStorage getRedisStorage() {
        return StorageFactory.createKVStorageByClassName("kd.bos.algo.storage.redis.RedisStorage");
    }

    private static KVStorage getHbaseStorage() {
        return StorageFactory.createKVStorageByClassName("kd.bos.algo.storage.hbase.HbaseStorage");
    }

    private static KVStorage getCephStorage() {
        return StorageFactory.createKVStorageByClassName("kd.bos.algo.storage.ceph.CephStorage");
    }

    private static FileSystemStorage getLocalStorage() {
        return new LocalStorage();
    }

    private static FileSystemStorage createByClassName(String className) {
        if (file_instances.containsKey(className)) {
            return file_instances.get(className);
        }
        try {
            Class<?> clazz = Class.forName(className);
            FileSystemStorage storage = (FileSystemStorage)clazz.newInstance();
            file_instances.put(className, storage);
            return storage;
        }
        catch (Exception e) {
            throw new AlgoException("Can't create storage by class:" + className, e);
        }
    }

    private static KVStorage createKVStorageByClassName(String className) {
        if (kv_instances.containsKey(className)) {
            return kv_instances.get(className);
        }
        try {
            Class<?> clazz = Class.forName(className);
            KVStorage storage = (KVStorage)clazz.newInstance();
            kv_instances.put(className, storage);
            return storage;
        }
        catch (Exception e) {
            throw new AlgoException("Can't create storage by class:" + className, e);
        }
    }
}

