/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.storage.ceph;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.storage.ceph.CephStorageServiceSwift;
import org.apache.http.pool.AbstractConnPool;
import org.apache.http.pool.PoolEntry;
import org.javaswift.joss.exception.NotFoundException;
import org.javaswift.joss.model.Container;
import org.javaswift.joss.model.StoredObject;

public class CephResourceRecycle
implements Runnable {
    private static CephStorageServiceSwift cephswift;

    @Override
    public void run() {
        if (!"ceph".equals(System.getProperty("algo.storage.datasetcache.type"))) {
            return;
        }
        if (null == cephswift) {
            cephswift = CephStorageServiceSwift.getInstance();
        }
        this.closeIdleConnections(300, TimeUnit.SECONDS);
        List<String> containers = this.listContainer();
        for (String cname : containers) {
            try {
                String createTime = this.get_is_Content(cname, "createTime");
                String timeout = this.get_is_Content(cname, "timeout");
                long cur = Long.valueOf(createTime) + Long.valueOf(timeout);
                if (System.currentTimeMillis() <= cur) continue;
                CephStorageServiceSwift cservie = CephStorageServiceSwift.getInstance();
                cservie.deleteBucket(cname);
            }
            catch (Exception e) {
                if (!(e instanceof NotFoundException)) continue;
            }
        }
    }

    private void closeIdleConnections(int idletime, TimeUnit tunit) {
        AbstractConnPool pool = (AbstractConnPool)this.getFiledValue("pool", cephswift.getConnectionManager());
        Set set = (Set)this.getFiledValue("leased", pool);
        PoolEntry[] pa = set.toArray(new PoolEntry[set.size()]);
        long time = tunit.toMillis(idletime);
        if (time < 0L) {
            time = 0L;
        }
        long deadline = System.currentTimeMillis() - time;
        for (PoolEntry entry : pa) {
            if (entry.getUpdated() > deadline) continue;
            pool.release(entry, false);
        }
    }

    private Object getFiledValue(String filedName, Object obj) {
        Field field = null;
        for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(filedName);
                break;
            }
            catch (Exception exception) {
                continue;
            }
        }
        if (field == null) {
            return null;
        }
        field.setAccessible(true);
        try {
            return field.get(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> listContainer() {
        ArrayList<String> list = new ArrayList<String>();
        Collection containers = cephswift.getAccount().list();
        for (Container currentContainer : containers) {
            list.add(currentContainer.getName());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String get_is_Content(String containerName, String objectName) throws IOException {
        StringBuffer sb = new StringBuffer();
        try (InputStream in = this.getObject(containerName, objectName);
             BufferedReader br = new BufferedReader(new InputStreamReader(in));){
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        return sb.toString();
    }

    private InputStream getObject(String containerName, String objectName) {
        Container container = cephswift.getAccount().getContainer(containerName);
        StoredObject object = container.getObject(objectName);
        return object.downloadObjectAsInputStream();
    }
}

