/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.storage.ceph;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.algo.storage.ceph.ICephStorageService;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.javaswift.joss.client.factory.AccountConfig;
import org.javaswift.joss.client.factory.AccountFactory;
import org.javaswift.joss.client.factory.AuthenticationMethod;
import org.javaswift.joss.model.Account;
import org.javaswift.joss.model.Container;
import org.javaswift.joss.model.StoredObject;

public class CephStorageServiceSwift
implements ICephStorageService {
    private static String username = null;
    private static String password = null;
    private static String authUrl = null;
    private static final String CONFIGKEY_PRE = "algo.storage.ceph.";
    public static final String CONFIGKEY_USER = "algo.storage.ceph.user";
    public static final String CONFIGKEY_KEY = "algo.storage.ceph.key";
    public static final String CONFIGKEY_URL = "algo.storage.ceph.url";
    private Account account;
    private static CephStorageServiceSwift instance;
    private PoolingClientConnectionManager connectionManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CephStorageServiceSwift getInstance() {
        if (null != instance) return instance;
        Class<CephStorageServiceSwift> clazz = CephStorageServiceSwift.class;
        synchronized (CephStorageServiceSwift.class) {
            if (null != instance) return instance;
            instance = new CephStorageServiceSwift();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private CephStorageServiceSwift() {
        AccountConfig config = new AccountConfig();
        username = System.getProperty(CONFIGKEY_USER);
        password = System.getProperty(CONFIGKEY_KEY);
        authUrl = System.getProperty(CONFIGKEY_URL);
        if (username == null || password == null || authUrl == null) {
            throw new KDException(BosErrorCode.hbaseRead, new Object[]{"Not yet config ceph of user/pass/url "});
        }
        config.setUsername(username);
        config.setPassword(password);
        config.setAuthUrl(authUrl);
        config.setAuthenticationMethod(AuthenticationMethod.BASIC);
        this.connectionManager = this.initConnectionManager();
        this.account = new AccountFactory(config).setHttpClient(this.getHttpClient(10000, 3000)).createAccount();
    }

    @Override
    public boolean deleteBucket(String containerName) {
        Container container = this.account.getContainer(containerName);
        List<String> ls = this.getContent(containerName);
        if (ls.isEmpty()) {
            container.delete();
        } else {
            for (String str : ls) {
                this.deleteObject(containerName, str);
            }
            container.delete();
        }
        return !container.exists();
    }

    @Override
    public boolean isBucketExists(String containerName) {
        Container container = this.account.getContainer(containerName);
        return container.exists();
    }

    @Override
    public void createBucket(String containName) {
        Container container = this.account.getContainer(containName);
        container.create();
    }

    @Override
    public boolean saveData(String containerName, String objectName, byte[] bs) {
        ByteArrayInputStream input = new ByteArrayInputStream(bs);
        Container container = this.account.getContainer(containerName);
        StoredObject object = container.getObject(objectName);
        object.uploadObject((InputStream)input);
        try {
            input.close();
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.cephWrite, new Object[0]);
        }
        return true;
    }

    @Override
    public InputStream getObject(String containerName, String objectName) {
        Container container = this.account.getContainer(containerName);
        StoredObject object = container.getObject(objectName);
        return object.downloadObjectAsInputStream();
    }

    private List<String> getContent(String containerName) {
        ArrayList<String> list = new ArrayList<String>();
        Container container = this.account.getContainer(containerName);
        Collection objects = container.list();
        for (StoredObject currentObject : objects) {
            list.add(currentObject.getName());
        }
        return list;
    }

    private boolean deleteObject(String containerName, String objectName) {
        Container container = this.account.getContainer(containerName);
        StoredObject object = container.getObject(objectName);
        object.delete();
        return !object.exists();
    }

    private HttpClient getHttpClient(int socketTimeout, int connectTimeout) {
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)this.connectionManager);
        HttpParams params = client.getParams();
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)socketTimeout);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)connectTimeout);
        return client;
    }

    private PoolingClientConnectionManager initConnectionManager() {
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager();
        connectionManager.setMaxTotal(400);
        connectionManager.setDefaultMaxPerRoute(200);
        return connectionManager;
    }

    Account getAccount() {
        return this.account;
    }

    PoolingClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }
}

