/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kd.bos.algo.AlgoException;

public class AlgoUtil {
    public static <T> void addArray(Collection<T> col, T[] array) {
        for (T t : array) {
            col.add(t);
        }
    }

    public static int compareNumber(Number n1, Number n2) {
        double d2;
        if (n1 == null && n2 == null) {
            return 0;
        }
        if (n1 == null) {
            return -1;
        }
        if (n2 == null) {
            return 1;
        }
        if (n1.getClass() == n2.getClass()) {
            return ((Comparable)((Object)n1)).compareTo(n2);
        }
        double d1 = n1.doubleValue();
        if (d1 == (d2 = n2.doubleValue())) {
            return 0;
        }
        if (d1 > d2) {
            return 1;
        }
        return -1;
    }

    public static final BigDecimal toBigDecimal(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof BigDecimal) {
            return (BigDecimal)v;
        }
        return new BigDecimal(v.toString());
    }

    public static final BigDecimal toBigDecimal(Number n) {
        if (n instanceof BigDecimal) {
            return (BigDecimal)n;
        }
        if (n instanceof Long) {
            return BigDecimal.valueOf((Long)n);
        }
        if (n instanceof Integer) {
            return BigDecimal.valueOf(((Integer)n).intValue());
        }
        if (n instanceof Double) {
            return BigDecimal.valueOf((Double)n);
        }
        return new BigDecimal(String.valueOf(n));
    }

    public static int compareValue(Object a, Object b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof Number && b instanceof Number) {
            return AlgoUtil.compareNumber((Number)a, (Number)b);
        }
        if (a instanceof Comparable && b instanceof Comparable) {
            return ((Comparable)a).compareTo((Comparable)b);
        }
        throw new AlgoException("Values not comparable:" + a + " and " + b);
    }

    public static boolean equal(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a instanceof Number && b instanceof Number) {
            return AlgoUtil.compareNumber((Number)a, (Number)b) == 0;
        }
        if (a instanceof Comparable && b instanceof Comparable) {
            return ((Comparable)a).compareTo((Comparable)b) == 0;
        }
        return a.equals(b);
    }

    public static boolean allSame(List<?> list1, List<?> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (list1.get(i) == list2.get(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean allEquals(List<?> list1, List<?> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (list1.get(i).equals(list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static <T> Set<T> newIdentityHashSet() {
        return Sets.newIdentityHashSet();
    }

    public static <T> Set<T> newIdentityHashSet(Iterable<T> elements) {
        Set<T> set = AlgoUtil.newIdentityHashSet();
        Iterables.addAll(set, elements);
        return set;
    }

    public static <V> ListenableFuture<V> toListenableFuture(final CompletableFuture<V> completableFuture) {
        SettableFuture future = SettableFuture.create();
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<V>(){

            public void onFailure(Throwable e) {
                completableFuture.cancel(true);
            }

            public void onSuccess(V result) {
            }
        });
        completableFuture.whenComplete((value, exception) -> {
            if (exception != null) {
                future.setException(exception);
            } else {
                future.set(value);
            }
        });
        return future;
    }
}

