/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util;

import org.apache.log4j.Logger;

public class ConfigUtil {
    private static Logger log = Logger.getLogger(ConfigUtil.class);

    public static int getInteger(String key, int defaultValue) {
        String str = System.getProperty(key);
        if (str != null) {
            try {
                return Integer.parseInt(str);
            }
            catch (Throwable t) {
                log.error((Object)("config error, " + str + " should be integer."));
            }
        }
        return defaultValue;
    }

    public static long getLong(String key, long defaultValue) {
        String str = System.getProperty(key);
        if (str != null) {
            try {
                return Long.parseLong(str);
            }
            catch (Throwable t) {
                log.error((Object)("config error, " + str + " should be long."));
            }
        }
        return defaultValue;
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String str = System.getProperty(key);
        if (str != null) {
            try {
                return Boolean.parseBoolean(str);
            }
            catch (Throwable t) {
                log.error((Object)("config error, " + str + " should be boolean."));
            }
        }
        return defaultValue;
    }
}

