/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.datatype.AnyType;

public class DataTypeMapper {
    private static Map<Class<?>, DataType> guessTypeMap = new HashMap();
    private static Map<DataType, Class<?>> reverseGuessTypeMap = new HashMap();

    public static Class<?> getClass(DataType dataType) {
        Class<?> cls = reverseGuessTypeMap.get(dataType);
        return cls == null ? Object.class : cls;
    }

    public static DataType get(Class<?> clazz) {
        return guessTypeMap.get(clazz);
    }

    static {
        guessTypeMap.put(Boolean.TYPE, DataType.BooleanType);
        guessTypeMap.put(Boolean.class, DataType.BooleanType);
        guessTypeMap.put(String.class, DataType.StringType);
        guessTypeMap.put(Integer.TYPE, DataType.IntegerType);
        guessTypeMap.put(Integer.class, DataType.IntegerType);
        guessTypeMap.put(Long.TYPE, DataType.LongType);
        guessTypeMap.put(Long.class, DataType.LongType);
        guessTypeMap.put(Double.TYPE, DataType.DoubleType);
        guessTypeMap.put(Double.class, DataType.DoubleType);
        guessTypeMap.put(BigDecimal.class, DataType.BigDecimalType);
        guessTypeMap.put(Date.class, DataType.DateType);
        guessTypeMap.put(java.sql.Date.class, DataType.TimestampType);
        guessTypeMap.put(Timestamp.class, DataType.TimestampType);
        reverseGuessTypeMap.put(DataType.BooleanType, Boolean.class);
        reverseGuessTypeMap.put(DataType.StringType, String.class);
        reverseGuessTypeMap.put(DataType.IntegerType, Integer.class);
        reverseGuessTypeMap.put(DataType.LongType, Long.class);
        reverseGuessTypeMap.put(DataType.DoubleType, Double.class);
        reverseGuessTypeMap.put(DataType.BigDecimalType, BigDecimal.class);
        reverseGuessTypeMap.put(DataType.DateType, Date.class);
        reverseGuessTypeMap.put(DataType.TimestampType, Timestamp.class);
        reverseGuessTypeMap.put(DataType.NullType, Object.class);
        reverseGuessTypeMap.put(DataType.UnknownType, Object.class);
        reverseGuessTypeMap.put(AnyType.instance, Object.class);
    }
}

