/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.resource;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Resource
implements Serializable {
    private static final long serialVersionUID = 1004937060457771270L;
    protected transient boolean closed;
    private transient AtomicInteger refCount = new AtomicInteger(0);

    public void refer() {
        this.refCount.incrementAndGet();
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (this.unrefer()) {
            this.closed = true;
        }
    }

    public boolean closed() {
        return this.closed;
    }

    public boolean unrefer() {
        int i = this.refCount.decrementAndGet();
        if (i < 0) {
            i = 0;
        }
        if (i == 0) {
            this.realClose();
            return true;
        }
        return false;
    }

    public int getReferCount() {
        return this.refCount.get();
    }

    public abstract void checkClosed();

    public abstract void realClose();
}

