/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.resource;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.AlgoException;
import kd.bos.algo.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceHolder {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ArrayList<Resource> list = new ArrayList(2);
    private ArrayList<Resource> subList = new ArrayList(2);

    public abstract String getName();

    public void holdResource(Resource resource) {
        this.list.add(resource);
    }

    public void holdSubResource(Resource resource) {
        this.subList.add(resource);
    }

    public void removeResource(Resource resource) {
        this.list.remove(resource);
    }

    public void closeAllSubResources() {
        this._closeAllResources(this.subList, false);
    }

    public void closeAllSubResources(boolean throwException) {
        this._closeAllResources(this.subList, throwException);
    }

    public void closeAllResources() {
        this._closeAllResources(this.list, false);
    }

    public void closeAllResources(boolean throwException) {
        this._closeAllResources(this.list, throwException);
    }

    private void _closeAllResources(List<Resource> list, boolean throwException) {
        for (Resource resource : list) {
            if (resource.closed()) continue;
            resource.close();
            String message = "Resource " + resource.getClass() + " in " + this.getName() + " not closed normally.";
            this.logger.warn(message);
            if (throwException) {
                throw new AlgoException(message);
            }
            if (resource.getReferCount() <= 0) continue;
            resource.realClose();
            message = "Resource " + resource.getClass() + " in " + this.getName() + " not closed normally, close it automatically!";
            this.logger.error(message);
            if (!throwException) continue;
            throw new AlgoException(message);
        }
        list.clear();
    }
}

