/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.util.sizer;

import org.ehcache.sizeof.SizeOf;
import org.ehcache.sizeof.filters.SizeOfFilter;

public class ObjectSizerSampler
implements Runnable {
    private int count = 1;
    private long sum = 0L;
    private int size;
    private Object object;
    private SizeOf sizeOf = SizeOf.newInstance((SizeOfFilter[])new SizeOfFilter[0]);
    private String name;

    public ObjectSizerSampler(int defaultSize, String name) {
        this.sum = defaultSize;
        this.size = defaultSize;
        this.name = name;
        this.start();
    }

    public void start() {
        new Thread((Runnable)this, this.name).start();
    }

    public void addObject(Object o) {
        this.object = o;
    }

    public long getSize() {
        return this.size;
    }

    @Override
    public void run() {
        while (true) {
            if (this.count == Integer.MAX_VALUE) {
                this.count = 1;
                this.sum = this.size;
            }
            if (this.object != null) {
                Object v = this.object;
                this.object = null;
                if (v != null) {
                    this.calc(v);
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void calc(Object v) {
        ++this.count;
        this.sum += this.sizeOf.deepSizeOf(new Object[]{v});
        if (this.count % 10 == 0) {
            this.size = (int)(1.0 * (double)this.sum / (double)this.count);
        }
    }
}

