/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox;

import java.util.ArrayList;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Field;
import kd.bos.algo.JoinHint;
import kd.bos.algo.JoinType;
import kd.bos.algo.RowMeta;
import kd.bos.algo.util.Tuple2;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JoinFunction;
import kd.bos.algox.core.AbstractDataSetX;
import kd.bos.algox.core.JobContext;
import kd.bos.algox.core.JoinSelectedField;

public class JoinDataSetX
extends AbstractDataSetX {
    private JoinType joinType;
    private ArrayList<Tuple2<String, String>> onList = new ArrayList();
    private AbstractDataSetX leftDataSet;
    private AbstractDataSetX rightDataSet;
    private ArrayList<JoinSelectedField> selectFields = new ArrayList();
    private JoinHint hint;
    private JoinFunction func;

    public JoinDataSetX(JobContext context, DataSetX source1, DataSetX source2, JoinType joinType) {
        super(context, source1, source2);
        this.leftDataSet = (AbstractDataSetX)source1;
        this.rightDataSet = (AbstractDataSetX)source2;
        this.joinType = joinType;
    }

    public JoinDataSetX on(String leftField, String rightField) {
        this.onList.add(new Tuple2<String, String>(leftField, rightField));
        return this;
    }

    public JoinDataSetX select(String[] leftFields, String[] rightFields) {
        String[] parts;
        String name;
        String alias;
        if (leftFields != null) {
            for (String expr : leftFields) {
                alias = null;
                name = expr.startsWith("left.") ? expr.substring(5) : expr;
                parts = name.split(" ");
                if (parts.length > 2) {
                    throw new AlgoException("Illegal field: " + expr);
                }
                if (parts.length == 2) {
                    name = parts[0];
                    alias = parts[1];
                }
                this.addField(true, name, alias, expr);
            }
        }
        if (rightFields != null) {
            for (String expr : rightFields) {
                int index;
                alias = null;
                name = expr.startsWith("right.") ? expr.substring(6) : expr;
                parts = name.split(" ");
                if (parts.length > 2) {
                    throw new AlgoException("Illegal field: " + expr);
                }
                if (parts.length == 2) {
                    name = parts[0];
                    alias = parts[1];
                }
                if ((index = this.rightDataSet.getRowMeta().getFieldIndex(name, false)) < 0) {
                    throw new AlgoException("Field " + expr + " not found.");
                }
                this.selectFields.add(new JoinSelectedField(false, name, index, alias));
            }
        }
        return this;
    }

    private void addField(boolean left, String name, String alias, String expr) {
        AbstractDataSetX x = left ? this.leftDataSet : this.rightDataSet;
        int index = x.getRowMeta().getFieldIndex(name, false);
        if (index < 0) {
            throw new AlgoException("Field " + expr + " not found.");
        }
        this.selectFields.add(new JoinSelectedField(left, name, index, alias));
    }

    @Override
    public JoinDataSetX select(String ... fields) {
        for (String expr : fields) {
            String alias = null;
            String[] parts = expr.split(" ");
            if (parts.length > 2) {
                throw new AlgoException("Illegal field: " + expr);
            }
            if (parts.length == 2) {
                expr = parts[0];
                alias = parts[1];
            }
            if (expr.startsWith("left.")) {
                this.addField(true, expr.substring(5), alias, expr);
                continue;
            }
            if (expr.startsWith("right.")) {
                this.addField(false, expr.substring(6), alias, expr);
                continue;
            }
            int index = this.leftDataSet.getRowMeta().getFieldIndex(expr, false);
            if (index < 0) {
                index = this.rightDataSet.getRowMeta().getFieldIndex(expr, false);
                if (index < 0) {
                    throw new AlgoException("Field " + expr + " not found.");
                }
                this.selectFields.add(new JoinSelectedField(false, expr, index, alias));
                continue;
            }
            this.selectFields.add(new JoinSelectedField(true, expr, index, alias));
        }
        return this;
    }

    public JoinDataSetX withFunc(JoinFunction func) {
        this.func = func;
        return this;
    }

    public JoinDataSetX hint(JoinHint hint) {
        this.hint = hint;
        return this;
    }

    @Override
    protected RowMeta createRowMeta() {
        if (this.func != null) {
            return this.func.getResultRowMeta();
        }
        if (this.selectFields.isEmpty()) {
            return this.createFullRowMeta();
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (JoinSelectedField sf : this.selectFields) {
            Field f;
            if (sf.left) {
                f = this.leftDataSet.getRowMeta().getField(sf.fieldIndex);
                fields.add(new Field(sf.alias, f.getDataType()));
                continue;
            }
            f = this.rightDataSet.getRowMeta().getField(sf.fieldIndex);
            fields.add(new Field(sf.alias, f.getDataType()));
        }
        return new RowMeta(fields.toArray(new Field[fields.size()]));
    }

    private RowMeta createFullRowMeta() {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : this.leftDataSet.getRowMeta().getFields()) {
            fields.add(field);
        }
        for (Field field : this.rightDataSet.getRowMeta().getFields()) {
            fields.add(field);
        }
        return new RowMeta(fields.toArray(new Field[fields.size()]));
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public ArrayList<Tuple2<String, String>> getOnList() {
        return this.onList;
    }

    public ArrayList<JoinSelectedField> getSelectFields() {
        return this.selectFields;
    }

    public JoinHint getHint() {
        return this.hint;
    }

    public JoinFunction getFunc() {
        return this.func;
    }
}

