/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.RowFeature;
import kd.bos.algo.RowMeta;

public final class RowX
implements RowFeature,
Serializable {
    private static final long serialVersionUID = -1553549880415022925L;
    private Object[] values;

    public RowX(int length) {
        this.values = new Object[length];
    }

    public RowX(Object[] values) {
        this.values = values;
    }

    public final void setValues(Object[] values) {
        this.values = values;
    }

    @Override
    public final Object get(int index) {
        return this.values[index];
    }

    public final void set(int index, Object value) {
        this.values[index] = value;
    }

    public final int size() {
        return this.values.length;
    }

    public final Object[] values() {
        return this.values;
    }

    public String toString() {
        return Arrays.toString(this.values);
    }

    public String getString(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            return (String)v;
        }
        return (String)DataType.convertValue(DataType.StringType, v);
    }

    public Integer getInteger(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        return (Integer)DataType.convertValue(DataType.IntegerType, v);
    }

    public Long getLong(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof Long) {
            return (Long)v;
        }
        return (Long)DataType.convertValue(DataType.LongType, v);
    }

    public Boolean getBoolean(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return (Boolean)DataType.convertValue(DataType.BooleanType, v);
    }

    public BigDecimal getBigDecimal(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof BigDecimal) {
            return (BigDecimal)v;
        }
        return (BigDecimal)DataType.convertValue(DataType.BigDecimalType, v);
    }

    public Double getDouble(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof Double) {
            return (Double)v;
        }
        return (Double)DataType.convertValue(DataType.DoubleType, v);
    }

    public Date getDate(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof Date) {
            return (Date)v;
        }
        return (Date)DataType.convertValue(DataType.DateType, v);
    }

    public Timestamp getTimestamp(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof Timestamp) {
            return (Timestamp)v;
        }
        return (Timestamp)DataType.convertValue(DataType.TimestampType, v);
    }

    public Map<String, Object> toMap(RowMeta rowMeta, Map<String, Object> reuse) {
        if (reuse == null) {
            reuse = new HashMap<String, Object>(rowMeta.getFieldCount());
        }
        for (int i = 0; i < this.values.length; ++i) {
            reuse.put(rowMeta.getFieldAlias(i), this.values[i]);
        }
        return reuse;
    }

    public RowX copy() {
        Object[] copy = Arrays.copyOf(this.values, this.values.length);
        return new RowX(copy);
    }
}

