/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.core;

import com.google.common.base.Preconditions;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.algox.core.AbstractDataSetX;
import kd.bos.algox.core.JobContext;

public class SortGlobalDataSetX
extends AbstractDataSetX {
    private String[] fields;
    private boolean[] desces;

    public SortGlobalDataSetX(JobContext context, DataSetX source, String[] exprs) {
        super(context, source);
        Preconditions.checkArgument((exprs != null && exprs.length > 0 ? 1 : 0) != 0, (Object)"sort exprs can't be null.");
        this.parse(exprs);
    }

    private void parse(String[] exprs) {
        this.fields = new String[exprs.length];
        this.desces = new boolean[exprs.length];
        for (int i = 0; i < exprs.length; ++i) {
            String[] parts = exprs[i].split(" ");
            this.fields[i] = parts[0];
            boolean asc = parts.length > 1 ? "asc".equalsIgnoreCase(parts[1]) : true;
            this.desces[i] = !asc;
        }
    }

    @Override
    protected RowMeta createRowMeta() {
        return ((AbstractDataSetX)this.getSource()).getRowMeta();
    }

    public String[] getFields() {
        return this.fields;
    }

    public boolean[] getDesces() {
        return this.desces;
    }
}

