/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.cube.a;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.algox.cube.Dimension;
import kd.bos.algox.cube.DimensionBuilder;
import kd.bos.algox.cube.DimensionMeta;
import kd.bos.algox.cube.a.ADimension;
import kd.bos.algox.cube.a.AMember;
import kd.bos.algox.cube.a.MemberSorter;

public class ADimensionBuilder
implements DimensionBuilder {
    private HashMap<Object, AMember> memberMap = new HashMap();
    private DimensionMeta meta;
    private int globalOrder = 1;

    public ADimensionBuilder(DimensionMeta meta) {
        this.meta = meta;
    }

    @Override
    public void add(Object id, Object parentId, Object[] attValues) {
        AMember member = new AMember(id, parentId, attValues);
        member.globalOrder = this.globalOrder++;
        this.memberMap.put(id, member);
    }

    @Override
    public Dimension build() {
        ArrayList<AMember> rootMembers = new ArrayList<AMember>();
        ArrayList<AMember> allMembers = new ArrayList<AMember>();
        allMembers.addAll(this.memberMap.values());
        if (this.meta.getParentIdField() == null) {
            rootMembers = allMembers;
            for (AMember member : rootMembers) {
                member.setParentId(null);
            }
        } else {
            for (AMember member : allMembers) {
                AMember parentMember = this.memberMap.get(member.getParentId());
                if (parentMember == null) {
                    member.setParentId(null);
                    rootMembers.add(member);
                    continue;
                }
                member.setParentMember(parentMember);
            }
            for (AMember member : allMembers) {
                member.sortChildren(this.meta.getSortAttIndex());
            }
            if (rootMembers.size() == allMembers.size()) {
                rootMembers = allMembers;
            }
        }
        MemberSorter.sort(rootMembers, this.meta.getSortAttIndex());
        return new ADimension(this.meta, this.memberMap, rootMembers);
    }
}

