/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.datachannel.mem;

import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.dataset.store.StoreDataSet;
import kd.bos.algo.env.Environment;
import kd.bos.algox.datachannel.ChannelInput;
import kd.bos.algox.datachannel.mem.MemDataSetCache;

class MemChannelInput
implements ChannelInput {
    DataSet dataSet;
    private String id;

    public MemChannelInput(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void open() {
        Object v = MemDataSetCache.get(this.id, true);
        if (v == null) {
            throw new AlgoException("Can't get DataSet from cache, cacheId:" + this.id);
        }
        if (v instanceof DataSet) {
            this.dataSet = (DataSet)v;
        } else {
            Algo algo = Algo.create("algox.memcache");
            this.dataSet = new StoreDataSet((Environment)algo, (Store)v);
        }
    }

    @Override
    public boolean hasNext() {
        return this.dataSet.hasNext();
    }

    @Override
    public Row next() {
        return this.dataSet.next();
    }

    @Override
    public void close() {
        this.dataSet.close();
    }

    @Override
    public RowMeta getRowMeta() {
        return this.dataSet.getRowMeta();
    }
}

