/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.datachannel.mem;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class MemDataSetCache {
    private static Logger log = Logger.getLogger(MemDataSetCache.class);
    private static Cache<String, AutoCloseable> c = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<String, AutoCloseable>(){

        public void onRemoval(RemovalNotification<String, AutoCloseable> n) {
            if (n.wasEvicted()) {
                try {
                    ((AutoCloseable)n.getValue()).close();
                }
                catch (Throwable t) {
                    log.error((Object)t);
                }
            }
        }
    }).build();
    private static ConcurrentMap<String, AutoCloseable> cache = c.asMap();

    public static <T> T remove(String cacheId) {
        return (T)cache.remove(cacheId);
    }

    public static void put(String cacheId, AutoCloseable c) {
        cache.put(cacheId, c);
    }

    public static <T> T get(String cacheId, boolean remove) {
        if (remove) {
            return (T)cache.remove(cacheId);
        }
        return (T)cache.get(cacheId);
    }
}

