/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.rollup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.util.Tuple2;
import kd.bos.algox.cube.Cube;
import kd.bos.algox.cube.CubeRow;
import kd.bos.algox.cube.CubeSet;
import kd.bos.algox.cube.Dimension;
import kd.bos.algox.cube.DimensionMeta;
import kd.bos.algox.cube.MeasureMeta;
import kd.bos.algox.rollup.CubeRollupRow;
import kd.bos.algox.rollup.RollupQuery;
import kd.bos.algox.rollup.RollupResult;
import kd.bos.algox.rollup.RollupRow;

public class CubeRollupResult
implements RollupResult {
    private RollupQuery query;
    private CubeSet cubeSet;
    private Cube cube;
    private Tuple2<Integer, Integer>[] groupFieldIndexMap;
    private HashMap<String, Tuple2<Integer, Integer>> groupFieldNameIndexMap = new HashMap();
    private Map<String, Integer> measureFieldNameIndex = new HashMap<String, Integer>();
    private int rowSize;
    private int rowGroupFieldSize;

    public CubeRollupResult(Cube cube, CubeSet cubeSet, RollupQuery query) {
        this.cube = cube;
        this.cubeSet = cubeSet;
        this.query = query;
        this.init();
    }

    @Override
    public int getColumnCount() {
        return this.rowSize;
    }

    @Override
    public int getGroupColumnCount() {
        return this.rowGroupFieldSize;
    }

    private void init() {
        Dimension[] dims = this.cube.getDimensions();
        ArrayList<Tuple2<Integer, Integer>> groupFieldIndexList = new ArrayList<Tuple2<Integer, Integer>>();
        for (int i = 0; i < dims.length; ++i) {
            DimensionMeta meta = dims[i].getMeta();
            String[] attFields = meta.getAttributeFields();
            for (int j = 0; j < meta.getAttributeCount(); ++j) {
                Tuple2<Integer, Integer> tuple = new Tuple2<Integer, Integer>(i, j);
                groupFieldIndexList.add(tuple);
                this.groupFieldNameIndexMap.putIfAbsent(attFields[j], tuple);
            }
        }
        this.groupFieldIndexMap = groupFieldIndexList.toArray(new Tuple2[groupFieldIndexList.size()]);
        this.rowGroupFieldSize = this.groupFieldIndexMap.length;
        MeasureMeta[] measures = this.cube.getMeta().getMeasures();
        this.rowSize = this.rowGroupFieldSize + measures.length;
        for (int i = 0; i < measures.length; ++i) {
            this.measureFieldNameIndex.put(measures[i].getField(), i);
        }
    }

    @Override
    public Iterator<RollupRow> iterator() {
        final Iterator cubeIter = this.cubeSet.iterator();
        return new Iterator<RollupRow>(){

            @Override
            public boolean hasNext() {
                return cubeIter.hasNext();
            }

            @Override
            public RollupRow next() {
                return CubeRollupResult.this.convertRow((CubeRow)cubeIter.next());
            }
        };
    }

    protected RollupRow convertRow(CubeRow row) {
        if (row == null) {
            return null;
        }
        return new CubeRollupRow(row, this.rowSize, this.rowGroupFieldSize, this.groupFieldIndexMap, this.groupFieldNameIndexMap, this.measureFieldNameIndex);
    }

    @Override
    public RollupQuery getQuery() {
        return this.query;
    }
}

