/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.rollup;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.util.Tuple2;
import kd.bos.algox.cube.CubeRow;
import kd.bos.algox.cube.Member;
import kd.bos.algox.rollup.RollupRow;

public class CubeRollupRow
implements RollupRow {
    private CubeRow cubeRow;
    private boolean isAggregateRow = false;
    int[] aggGroupIndexes = null;
    private int size;
    private int groupFieldSize;
    private Tuple2<Integer, Integer>[] groupFieldIndexMap;
    private Map<String, Tuple2<Integer, Integer>> groupFieldNameIndexMap;
    private Map<String, Integer> measureFieldNameIndex;

    public CubeRollupRow(CubeRow cubeRow, int size, int groupFieldSize, Tuple2<Integer, Integer>[] groupFieldIndexMap, Map<String, Tuple2<Integer, Integer>> groupFieldNameIndexMap, Map<String, Integer> measureFieldNameIndex) {
        this.cubeRow = cubeRow;
        this.size = size;
        this.groupFieldSize = groupFieldSize;
        this.groupFieldIndexMap = groupFieldIndexMap;
        this.groupFieldNameIndexMap = groupFieldNameIndexMap;
        this.measureFieldNameIndex = measureFieldNameIndex;
        this.init();
    }

    private void init() {
        int i;
        Member[] members = this.cubeRow.getMembers();
        ArrayList<Integer> aggregateGroupIndexes = null;
        for (i = 0; i < members.length; ++i) {
            if (!members[i].isTotal()) continue;
            if (aggregateGroupIndexes == null) {
                aggregateGroupIndexes = new ArrayList<Integer>(members.length);
            }
            aggregateGroupIndexes.add(i);
            this.isAggregateRow = true;
        }
        if (this.isAggregateRow) {
            this.aggGroupIndexes = new int[aggregateGroupIndexes.size()];
            for (i = 0; i < this.aggGroupIndexes.length; ++i) {
                this.aggGroupIndexes[i] = (Integer)aggregateGroupIndexes.get(i);
            }
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object get(int index) {
        if (index < this.groupFieldSize) {
            Tuple2<Integer, Integer> tuple = this.groupFieldIndexMap[index];
            Member member = this.cubeRow.getMembers()[(Integer)tuple.t1];
            if (member.isTotal()) {
                return null;
            }
            return member.getAttributeValue((Integer)tuple.t2);
        }
        return this.cubeRow.getValues()[index - this.groupFieldSize];
    }

    @Override
    public Object get(String field) {
        Tuple2<Integer, Integer> tuple = this.groupFieldNameIndexMap.get(field);
        if (tuple != null) {
            Member member = this.cubeRow.getMembers()[(Integer)tuple.t1];
            if (member.isTotal()) {
                return null;
            }
            return member.getAttributeValue((Integer)tuple.t2);
        }
        int index = this.measureFieldNameIndex.get(field);
        if (index > -1) {
            return this.cubeRow.getValues()[index];
        }
        throw new AlgoException("Field " + field + " not found.");
    }

    @Override
    public String getString(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            return (String)v;
        }
        return (String)DataType.convertValue(DataType.StringType, v);
    }

    @Override
    public String getString(String field) {
        Object v = this.get(field);
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            return (String)v;
        }
        return (String)DataType.convertValue(DataType.StringType, v);
    }

    @Override
    public Integer getInteger(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        return (Integer)DataType.convertValue(DataType.IntegerType, v);
    }

    @Override
    public Integer getInteger(String field) {
        Object v = this.get(field);
        if (v == null) {
            return null;
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        return (Integer)DataType.convertValue(DataType.IntegerType, v);
    }

    @Override
    public Long getLong(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof Long) {
            return (Long)v;
        }
        return (Long)DataType.convertValue(DataType.LongType, v);
    }

    @Override
    public Long getLong(String field) {
        Object v = this.get(field);
        if (v == null) {
            return null;
        }
        if (v instanceof Long) {
            return (Long)v;
        }
        return (Long)DataType.convertValue(DataType.LongType, v);
    }

    @Override
    public Boolean getBoolean(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return (Boolean)DataType.convertValue(DataType.BooleanType, v);
    }

    @Override
    public Boolean getBoolean(String field) {
        Object v = this.get(field);
        if (v == null) {
            return null;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return (Boolean)DataType.convertValue(DataType.BooleanType, v);
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof BigDecimal) {
            return (BigDecimal)v;
        }
        return (BigDecimal)DataType.convertValue(DataType.BigDecimalType, v);
    }

    @Override
    public BigDecimal getBigDecimal(String field) {
        Object v = this.get(field);
        if (v == null) {
            return null;
        }
        if (v instanceof BigDecimal) {
            return (BigDecimal)v;
        }
        return (BigDecimal)DataType.convertValue(DataType.BigDecimalType, v);
    }

    @Override
    public Double getDouble(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof Double) {
            return (Double)v;
        }
        return (Double)DataType.convertValue(DataType.DoubleType, v);
    }

    @Override
    public Double getDouble(String field) {
        Object v = this.get(field);
        if (v == null) {
            return null;
        }
        if (v instanceof Double) {
            return (Double)v;
        }
        return (Double)DataType.convertValue(DataType.DoubleType, v);
    }

    @Override
    public Date getDate(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof Date) {
            return (Date)v;
        }
        return (Date)DataType.convertValue(DataType.DateType, v);
    }

    @Override
    public Date getDate(String field) {
        Object v = this.get(field);
        if (v == null) {
            return null;
        }
        if (v instanceof Date) {
            return (Date)v;
        }
        return (Date)DataType.convertValue(DataType.DateType, v);
    }

    @Override
    public Timestamp getTimestamp(int index) {
        Object v = this.get(index);
        if (v == null) {
            return null;
        }
        if (v instanceof Timestamp) {
            return (Timestamp)v;
        }
        return (Timestamp)DataType.convertValue(DataType.TimestampType, v);
    }

    @Override
    public Timestamp getTimestamp(String field) {
        Object v = this.get(field);
        if (v == null) {
            return null;
        }
        if (v instanceof Timestamp) {
            return (Timestamp)v;
        }
        return (Timestamp)DataType.convertValue(DataType.TimestampType, v);
    }

    @Override
    public boolean isAggregateRow() {
        return this.isAggregateRow;
    }

    @Override
    public String getAggregateTitle(int groupIndex) {
        return null;
    }

    @Override
    public int[] getAggregateGroupIndexes() {
        return this.aggGroupIndexes;
    }
}

