/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap;

import java.io.Serializable;
import kd.bos.algo.olap.Cube;
import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.MetadataAPI;
import kd.bos.algo.olap.Schema;
import kd.bos.algo.olap.cubedata.CubeDataBuilder;
import kd.bos.algo.olap.cubedata.CubeDataReader;
import kd.bos.algo.olap.cubedata.ICubeData;
import kd.bos.algo.olap.impl.BBFilterIndexes;
import kd.bos.algo.olap.impl.CellReaderImpl;
import kd.bos.algo.olap.impl.ConnectionImpl;
import kd.bos.algo.olap.impl.CubeEvaluateContext;
import kd.bos.algo.olap.impl.DimensionImpl;
import kd.bos.algo.olap.impl.MetadataAPIImpl;
import kd.bos.algo.olap.impl.SchemaImpl;
import kd.bos.algo.olap.impl.SchemaReaderImpl;
import kd.bos.algo.olap.impl.Stats;
import kd.bos.algo.olap.mdx.CellReader;
import kd.bos.algo.olap.mdx.SchemaReader;
import org.apache.log4j.Logger;

public class Database
implements Serializable {
    private static Logger logger = Logger.getLogger(Database.class);
    public Schema schema;
    ICubeData cubeData;
    private boolean builded;
    private CubeDataBuilder builder;
    private MetadataAPIImpl metadataAPI;
    private SchemaReaderImpl schemaReader;
    private CubeEvaluateContext evaluateContext;
    private ConnectionImpl con;

    public Database(Schema _schema) {
        this.schema = _schema;
        this.schemaReader = new SchemaReaderImpl((SchemaImpl)this.schema);
        this.metadataAPI = new MetadataAPIImpl(this.schemaReader);
    }

    public SchemaReader getSchemaReader() {
        return this.schemaReader;
    }

    private void build() {
        if (this.builder != null) {
            this.builder.build();
        }
        this.builded = true;
    }

    private BBFilterIndexes buildScopeIndexes() {
        Dimension[] dimensionArray = this.schema.getCube().getDimensions();
        int n = dimensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Dimension dim = dimensionArray[n2];
            if (((DimensionImpl)dim).hasCalcMembers()) {
                return dim.buildScopeIndexes(this.getEvaluateContext().createEvaluator());
            }
            ++n2;
        }
        return null;
    }

    public void setBuilder(CubeDataBuilder builder) {
        this.builder = builder;
    }

    public CubeDataReader getCubeDataReader(String name) {
        if (!this.builded) {
            this.build();
            BBFilterIndexes bbIndexes = this.buildScopeIndexes();
            if (bbIndexes != null) {
                this.cubeData.setCalcBBFilterIndexes(bbIndexes);
            }
        }
        return (CubeDataReader)((Object)this.cubeData);
    }

    public CubeDataReader getCubeDataReader(Cube cube) {
        return this.getCubeDataReader(cube.getName());
    }

    public MetadataAPI getMetadataAPI() {
        return this.metadataAPI;
    }

    public CellReader getCellReader(String name) {
        return new CellReaderImpl(this);
    }

    public void setData(String name, ICubeData data) {
        this.cubeData = data;
    }

    public void printStatistics(Stats stats) {
        this.cubeData.printStatistics(stats);
    }

    public void release() {
        this.schema = null;
        if (this.cubeData != null) {
            this.cubeData.release();
        }
    }

    public String getDefaultCubeName() {
        return this.schema.getCube().getName();
    }

    public CubeEvaluateContext getEvaluateContext() {
        if (this.evaluateContext == null) {
            this.evaluateContext = new CubeEvaluateContext(this);
        }
        return this.evaluateContext;
    }

    public void setConnection(ConnectionImpl con) {
        this.con = con;
    }

    public ConnectionImpl getConnection() {
        return this.con;
    }
}

