/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kd.bos.algo.olap.Database;
import kd.bos.algo.olap.OlapConfig;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.config.Config_CN;
import kd.bos.algo.olap.config.Config_EN;
import kd.bos.algo.olap.config.Config_TW;
import kd.bos.algo.olap.dbsource.TableManager;
import kd.bos.algo.olap.def.SchemaDef;
import kd.bos.algo.olap.def.SchemaParser;
import kd.bos.algo.olap.impl.BuildContext;
import kd.bos.algo.olap.impl.CubeBuilder;
import kd.bos.algo.olap.impl.SchemaImpl;
import kd.bos.algo.olap.impl.Stats;
import org.jdom.Document;
import org.jdom.JDOMException;

public class Engine {
    private static Hashtable resources = new Hashtable();

    static {
        Config_CN cn = new Config_CN();
        Config_TW tw = new Config_TW();
        Config_EN en = new Config_EN();
        Engine.setLocalResource(Locale.CHINA, cn);
        Engine.setLocalResource(Locale.CHINESE, cn);
        Engine.setLocalResource(Locale.SIMPLIFIED_CHINESE, cn);
        Engine.setLocalResource(Locale.TRADITIONAL_CHINESE, tw);
        Engine.setLocalResource(Locale.TAIWAN, tw);
        Engine.setLocalResource(Locale.US, en);
        Engine.setLocalResource(Locale.UK, en);
        Engine.setLocalResource(Locale.CANADA, en);
        Engine.setLocalResource(Locale.ENGLISH, en);
    }

    public static Database build(SchemaDef schemaDef, Map params, OlapConfig config, Stats stats) throws OlapException, SQLException {
        if (config == null) {
            config = new OlapConfig();
        }
        if (stats == null) {
            stats = new Stats();
        }
        TableManager tableManager = CubeBuilder.getTableManager(schemaDef, params, config, stats);
        BuildContext buildContext = new BuildContext(tableManager, config);
        SchemaImpl schema = CubeBuilder.buildSchema(buildContext, schemaDef, true, stats);
        Database database = CubeBuilder.buildDatabase(buildContext, schema, schemaDef, config, stats);
        return database;
    }

    public static Database buildWithoutCheck(SchemaDef schemaDef, Map params, OlapConfig config, Stats stats) throws OlapException, SQLException {
        Stats.StatItem item = stats.createStatItem("create table manager");
        TableManager tableManager = CubeBuilder.getTableManager(schemaDef, params, config, stats);
        item.close();
        BuildContext buildContext = new BuildContext(tableManager, config);
        SchemaImpl schema = CubeBuilder.buildSchema(buildContext, schemaDef, false, stats);
        Database database = CubeBuilder.buildDatabase(buildContext, schema, schemaDef, config, stats);
        return database;
    }

    public static Database build(Document schema, Map parameters, OlapConfig config, Stats stats) throws OlapException, SQLException, JDOMException {
        return Engine.build(SchemaParser.parse(schema), parameters, config, stats);
    }

    public static Database build(SchemaDef schema, OlapConfig config, Stats stats) throws OlapException, SQLException {
        return Engine.build(schema, new HashMap(), config, stats);
    }

    public static Database build(Document schema, OlapConfig config, Stats stats) throws OlapException, SQLException {
        return Engine.build(SchemaParser.parse(schema), config, stats);
    }

    public static void setLocalResource(Locale locale, Properties props) {
        Properties res = (Properties)resources.get(locale);
        if (res == null) {
            res = new Properties();
            resources.put(locale, res);
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = props.getProperty(name);
            res.setProperty(name, value);
        }
    }

    public static String getResource(String name) {
        return Engine.getResource(Locale.getDefault(), name);
    }

    public static String getResource(Locale locale, String name) {
        return Engine.getResource(locale, name, null);
    }

    public static void setResource(Locale locale, String name, String value) {
        Properties res = (Properties)resources.get(locale);
        if (res == null) {
            res = new Properties();
            resources.put(locale, res);
        }
        res.put(name, value);
    }

    public static String getResource(Locale locale, String name, String defaultValue) {
        Properties res = (Properties)resources.get(locale);
        if (res == null) {
            res = (Properties)resources.get(Locale.US);
        }
        return res.getProperty(name, defaultValue);
    }

    public static Properties getResources(Locale locale) {
        Properties res = (Properties)resources.get(locale);
        if (res == null) {
            res = (Properties)resources.get(Locale.US);
        }
        return res;
    }
}

