/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap;

import com.kingdee.bos.ctrl.common.digitalstyle.Format;
import com.kingdee.bos.ctrl.common.digitalstyle.Formats;
import com.kingdee.bos.ctrl.common.variant.Variant;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import kd.bos.algo.olap.Cell;
import kd.bos.algo.olap.util.Util;

public class Formatter
implements Serializable {
    private static final long serialVersionUID = 6833357350405126869L;
    private String formatExp;
    private transient NumberFormat nf = null;
    private transient Format format = null;
    private transient String formatString = null;
    private transient String oldColor = null;
    private String color = null;
    private String bgColor = null;
    private String status = null;
    private String trend = null;

    public Formatter(String formatExp) {
        if (formatExp != null) {
            this.formatExp = formatExp.intern();
        }
        this.parseFormatString();
    }

    public String getFormatString() {
        return this.formatString;
    }

    private void parseFormatString() {
        block3: {
            String[] ss;
            if (this.formatExp == null || (ss = Util.seperateNames(this.formatExp, 124)).length <= 0) break block3;
            int i = 0;
            while (i < ss.length) {
                block5: {
                    String[] prop;
                    block6: {
                        block4: {
                            prop = Util.seperateNames(ss[i], 58);
                            if (prop.length != 1) break block4;
                            if (prop[0].length() == 0) break block5;
                            this.formatString = prop[0];
                            this.nf = new DecimalFormat(this.formatString);
                            this.format = Formats.getFormat((String)this.formatString);
                            break block6;
                        }
                        if (prop.length == 2 && prop[0].equalsIgnoreCase("number")) {
                            this.formatString = prop[1];
                            this.nf = new DecimalFormat(this.formatString);
                            this.format = Formats.getFormat((String)this.formatString);
                        }
                    }
                    if (prop.length == 2 && prop[0].equalsIgnoreCase("color")) {
                        this.oldColor = prop[1];
                    }
                }
                ++i;
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.formatExp);
        out.writeObject(this.color);
        out.writeObject(this.bgColor);
        out.writeObject(this.status);
        out.writeObject(this.trend);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.formatExp = (String)in.readObject();
        this.color = (String)in.readObject();
        this.bgColor = (String)in.readObject();
        this.status = (String)in.readObject();
        this.trend = (String)in.readObject();
        this.parseFormatString();
    }

    public String format(Object number) {
        if (number == null || number instanceof Cell && ((Cell)number).isNull() || number == Util.nullValue) {
            return null;
        }
        if (number instanceof String) {
            return (String)number;
        }
        if (this.formatString != null) {
            if (number instanceof Number) {
                Variant v = new Variant();
                Number n = (Number)number;
                if (number instanceof BigDecimal) {
                    v.setBigDecimal((BigDecimal)n);
                } else if (number instanceof Double) {
                    v.setDouble(n.doubleValue());
                } else if (number instanceof Float) {
                    v.setFloat(n.floatValue());
                } else if (number instanceof Integer) {
                    v.setInt(n.intValue());
                } else if (number instanceof Long) {
                    v.setLong(n.longValue());
                } else {
                    v.setObject((Object)n);
                }
                return this.format.format(v).toString();
            }
            return this.nf.format(number);
        }
        return number.toString();
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setBgColor(String bgColor) {
        this.bgColor = bgColor;
    }

    public String getColor() {
        if (this.color != null) {
            return this.color;
        }
        return this.oldColor;
    }

    public String getBgColor() {
        return this.bgColor;
    }
}

