/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.collection;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.collection.ArrayList;
import kd.bos.algo.olap.collection.IInnerList;
import kd.bos.algo.olap.collection.ListSortUtil;
import kd.bos.algo.olap.collection.Resetable;
import kd.bos.algo.olap.util.ObjectComparator;

public class UnionList
implements IInnerList {
    IInnerList[] lists;
    boolean sorted;

    UnionList(IInnerList list1, IInnerList list2) {
        this(new IInnerList[]{list1, list2});
    }

    UnionList(IInnerList[] lists) {
        this.lists = lists;
        this.merge();
    }

    public IInnerList getList(int index) {
        return this.lists[index];
    }

    @Override
    public IInnerList innerAdd(Object o) {
        IInnerList last = this.lists[this.lists.length - 1];
        this.lists[this.lists.length - 1] = last.innerAdd(o);
        if (this.lists[this.lists.length - 1] instanceof UnionList) {
            this.merge();
        }
        return this;
    }

    @Override
    public IInnerList innerAddList(IInnerList list) {
        if (list == this) {
            throw new IllegalArgumentException("List can't addList itself.");
        }
        if (list.size() == 1) {
            return this.innerAdd(list.get(0));
        }
        IInnerList last = this.lists[this.lists.length - 1];
        this.lists[this.lists.length - 1] = last = last.innerAddList(list);
        if (last instanceof UnionList) {
            this.merge();
        }
        return this;
    }

    @Override
    public Object get(int index) {
        this.rangeCheck(index);
        int i = 0;
        while (i < this.lists.length) {
            IInnerList list = this.lists[i];
            int size = list.size();
            if (index < size) {
                return list.get(index);
            }
            index -= size;
            ++i;
        }
        return null;
    }

    @Override
    public int size() {
        int size = 0;
        int i = 0;
        while (i < this.lists.length) {
            size += this.lists[i].size();
            ++i;
        }
        return size;
    }

    @Override
    public int realSize() {
        int size = 0;
        int i = 0;
        while (i < this.lists.length) {
            size += this.lists[i].realSize();
            ++i;
        }
        return size;
    }

    @Override
    public Iterator<?> iterator() {
        return new Itr();
    }

    private void rangeCheck(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public IInnerList subList(int begin, int end) {
        if (begin == end) {
            return IInnerList.EMPTY;
        }
        if (begin > end) {
            throw new IllegalArgumentException("Illegal Argument subList(" + begin + "," + end + ")");
        }
        if (begin < 0 || end > this.size()) {
            throw new IndexOutOfBoundsException("subList(" + begin + "," + end + "),size=" + this.size());
        }
        int index1 = 0;
        int index2 = 0;
        int offset1 = 0;
        int offset2 = 0;
        int size = 0;
        boolean found1 = false;
        boolean found2 = false;
        int i = 0;
        while (i < this.lists.length) {
            if (!found1 && size + this.lists[i].size() >= begin) {
                index1 = i;
                offset1 = begin - size;
                found1 = true;
            }
            if (!found2 && size + this.lists[i].size() >= end) {
                index2 = i;
                offset2 = end - size;
                found2 = true;
            }
            size += this.lists[i].size();
            ++i;
        }
        if (index1 == index2) {
            return this.lists[index1].subList(offset1, offset2);
        }
        ArrayList container = new ArrayList();
        if (this.lists[index1].size() > offset1) {
            container.innerAdd(this.lists[index1].subList(offset1, this.lists[index1].size()));
        }
        while (++index1 < index2) {
            container.innerAdd(this.lists[index1]);
        }
        if (offset2 > 0) {
            container.innerAdd(this.lists[index2].subList(0, offset2));
        }
        IInnerList[] lists2 = (IInnerList[])container.toArray(new IInnerList[0]);
        UnionList ret = new UnionList(lists2);
        return ret;
    }

    @Override
    public boolean contains(Object o) {
        int i = 0;
        while (i < this.lists.length) {
            if (this.lists[i].contains(o)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] a = new Object[this.size()];
        int index = 0;
        Iterator<?> iter = this.iterator();
        while (iter.hasNext()) {
            a[index++] = iter.next();
        }
        return a;
    }

    @Override
    public Object[] toArray(Object[] a) {
        a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        int index = 0;
        Iterator<?> iter = this.iterator();
        while (iter.hasNext()) {
            a[index++] = iter.next();
        }
        return a;
    }

    @Override
    public Object getFirst() {
        int i = 0;
        while (i < this.lists.length) {
            if (!this.lists[i].isEmpty()) {
                return this.lists[i].getFirst();
            }
            ++i;
        }
        return null;
    }

    @Override
    public Object getLast() {
        int i = this.lists.length - 1;
        while (i >= 0) {
            if (!this.lists[i].isEmpty()) {
                return this.lists[i].getLast();
            }
            --i;
        }
        return null;
    }

    @Override
    public IInnerList innerAddFirst(Object o) {
        this.lists[0] = this.lists[0].innerAddFirst(o);
        if (this.lists[0] instanceof UnionList) {
            this.merge();
        }
        return this;
    }

    @Override
    public IInnerList innerAddArray(Object[] objects) {
        int index = this.lists.length - 1;
        this.lists[index] = this.lists[index].innerAddArray(objects);
        if (this.lists[index] instanceof UnionList) {
            this.merge();
        }
        return this;
    }

    private void merge() {
        java.util.ArrayList container = new java.util.ArrayList();
        this.getChildren(container, this);
        this.lists = container.toArray(new IInnerList[0]);
    }

    private void getChildren(java.util.ArrayList container, UnionList unionList) {
        IInnerList[] lists = unionList.lists;
        int i = 0;
        while (i < lists.length) {
            if (lists[i] instanceof UnionList) {
                this.getChildren(container, (UnionList)lists[i]);
            } else {
                container.add(lists[i]);
            }
            ++i;
        }
    }

    @Override
    public boolean isSorted() {
        return this.sorted;
    }

    @Override
    public IInnerList sort(ObjectComparator comparator) throws OlapException {
        return new ListSortUtil(this).sort(comparator);
    }

    @Override
    public IInnerList trimEmpty() {
        int i = 0;
        while (i < this.lists.length) {
            this.lists[i] = this.lists[i].trimEmpty();
            ++i;
        }
        return this;
    }

    class Itr
    implements Iterator,
    Resetable {
        Iterator[] itrs = null;
        Iterator cur = null;
        int index = 0;
        boolean passHasNext = false;

        Itr() {
            this.itrs = new Iterator[UnionList.this.lists.length];
            this.itrs[0] = this.cur = UnionList.this.lists[0].iterator();
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            this.passHasNext = true;
            if (this.cur.hasNext()) {
                return true;
            }
            if (this.index < UnionList.this.lists.length - 1) {
                if (this.itrs[this.index + 1] != null) {
                    this.cur = this.itrs[++this.index];
                } else {
                    this.itrs[this.index] = this.cur = UnionList.this.lists[++this.index].iterator();
                }
                return this.cur.hasNext();
            }
            return false;
        }

        public Object next() {
            if (!this.passHasNext && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.passHasNext = false;
            return this.cur.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            int i = 0;
            while (i < this.itrs.length) {
                ((Resetable)((Object)this.itrs[i])).reset();
                ++i;
            }
            this.index = 0;
            this.cur = this.itrs[0];
            this.passHasNext = false;
        }
    }
}

