/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.cubedata;

import java.util.ArrayList;
import kd.bos.algo.olap.Cube;
import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.impl.MemberImpl;

public abstract class DisableAggTester {
    public abstract boolean test(Member[] var1);

    public static DisableAggTester get(Cube cube) {
        ArrayList<Integer> list = new ArrayList<Integer>(1);
        Dimension[] dims = cube.getDimensions();
        int i = 0;
        while (i < dims.length) {
            if (dims[i].hasDisableAgg()) {
                list.add(i);
            }
            ++i;
        }
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return new OneDimensionDisableAggTester((Integer)list.get(0));
        }
        int[] indexes = new int[list.size()];
        int i2 = 0;
        while (i2 < indexes.length) {
            indexes[i2] = (Integer)list.get(i2);
            ++i2;
        }
        return new MultiDimensionDisableAggTester(indexes);
    }

    public static class MultiDimensionDisableAggTester
    extends DisableAggTester {
        private int[] dimIndexes;

        public MultiDimensionDisableAggTester(int[] dimIndexes) {
            this.dimIndexes = dimIndexes;
        }

        @Override
        public boolean test(Member[] members) {
            boolean b = false;
            int i = 0;
            while (i < this.dimIndexes.length) {
                if (((MemberImpl)members[this.dimIndexes[i]]).hasDisableAgg()) {
                    b = true;
                    break;
                }
                ++i;
            }
            if (!b) {
                return false;
            }
            i = 0;
            while (i < members.length) {
                if (!members[i].isLeaf()) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public static class OneDimensionDisableAggTester
    extends DisableAggTester {
        private int dimIndex;

        public OneDimensionDisableAggTester(int dimIndex) {
            this.dimIndex = dimIndex;
        }

        @Override
        public boolean test(Member[] members) {
            boolean b = ((MemberImpl)members[this.dimIndex]).hasDisableAgg();
            if (!b) {
                return false;
            }
            int i = 0;
            while (i < members.length) {
                if (i != this.dimIndex && !members[i].isLeaf()) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

