/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.dbsource;

import java.util.HashMap;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.dbsource.Table;

public class ArrayTable
implements Table {
    private Object[][] values;
    private String[] columnNames;
    private int[] columnTypes;
    private int colCount;
    private int rowCount;
    private int cursor = -1;
    private HashMap<String, Integer> columns = new HashMap();

    public ArrayTable(Object[][] values, String[] columnNames, int[] columnTypes) {
        this.values = values;
        this.columnNames = columnNames;
        this.columnTypes = columnTypes;
        this.colCount = columnNames.length;
        this.rowCount = values.length;
        int i = 0;
        while (i < this.colCount) {
            this.columns.put(columnNames[i].toLowerCase(), i);
            ++i;
        }
    }

    @Override
    public int getColumnCount() throws OlapException {
        return this.colCount;
    }

    @Override
    public int getColumnType(int index) throws OlapException {
        if (index < 0 || index >= this.colCount) {
            throw new OlapException("Index " + index + " is illegal.");
        }
        return this.columnTypes[index];
    }

    @Override
    public int getColumnIndex(String name) throws OlapException {
        Integer index = this.columns.get(name.toLowerCase());
        if (index == null) {
            throw new OlapException("Column '" + name + "' not found.");
        }
        return index;
    }

    @Override
    public String[] getColumnNames() throws OlapException {
        return this.columnNames;
    }

    @Override
    public boolean next() throws OlapException {
        ++this.cursor;
        return this.cursor < this.rowCount;
    }

    @Override
    public Object getValue(int index) throws OlapException {
        if (index < 0 || index >= this.colCount) {
            throw new OlapException("Index " + index + " is illegal.");
        }
        return this.values[this.cursor][index];
    }

    @Override
    public Object[] getValues() throws OlapException {
        return this.values[this.cursor];
    }

    @Override
    public void close() {
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void reset() {
        this.cursor = -1;
    }
}

