/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.dbsource;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.dbsource.MemoryTable;
import kd.bos.algo.olap.dbsource.ResultSetTable;
import kd.bos.algo.olap.dbsource.Table;
import kd.bos.algo.olap.dbsource.TableManager;
import kd.bos.algo.olap.dbsource.TableProvider;
import kd.bos.algo.olap.def.CubeDef;
import kd.bos.algo.olap.def.DimensionUsageDef;
import kd.bos.algo.olap.def.SchemaDef;
import kd.bos.algo.olap.def.TableDef;
import org.apache.log4j.Logger;

public class DefTableProvider
extends TableProvider {
    TableDef def;
    private static Logger logger = Logger.getLogger(DefTableProvider.class);

    DefTableProvider(TableManager manager, TableDef def) {
        super(manager);
        this.def = def;
    }

    public String[] getTableAndSql() {
        String tablename = null;
        String sql = null;
        if (this.def.sql == null) {
            tablename = this.def.name;
        } else if (this.def.sql.toLowerCase().indexOf("select") < 0) {
            tablename = this.def.sql;
        } else {
            StringTokenizer st = new StringTokenizer(this.def.sql, " \t\n\r\f,");
            int count = st.countTokens();
            if (count == 4 && "select".equalsIgnoreCase(st.nextToken())) {
                int i = 1;
                while (i < count - 2) {
                    st.nextToken();
                    ++i;
                }
                if ("from".equalsIgnoreCase(st.nextToken())) {
                    tablename = st.nextToken();
                }
            }
        }
        if (tablename == null) {
            tablename = String.valueOf(this.def.name) + "_";
            sql = this.def.sql;
        }
        return new String[]{tablename, sql};
    }

    public void joinSql(SchemaDef schemaDef, CubeDef cubeDef) throws SQLException, OlapException {
        String[] tableSql = this.getTableAndSql();
        String factTable = tableSql[0];
        String factSql = tableSql[1];
        ArrayList<String[]> dimList = new ArrayList<String[]>();
        int i = 0;
        while (i < cubeDef.dimensions.length) {
            DimensionUsageDef usage = (DimensionUsageDef)cubeDef.dimensions[i];
            String foreignKey = usage.foreignKey;
            String primaryKey = schemaDef.getDimensionDef((String)usage.name).primaryKey;
            String tableName = schemaDef.getDimensionDef((String)usage.name).table;
            DefTableProvider tableSource = (DefTableProvider)this.manager.getTableProvider(tableName);
            tableSql = tableSource.getTableAndSql();
            dimList.add(new String[]{tableSql[0], tableSql[1], primaryKey, foreignKey});
            ++i;
        }
        StringBuilder sb = new StringBuilder("select ").append(factTable);
        StringBuilder join = new StringBuilder();
        if (factSql == null) {
            sb.append(".* from ").append(factTable);
        } else {
            sb.append(".* from (").append(factSql).append(") as ").append(factTable);
        }
        int i2 = 0;
        while (i2 < dimList.size()) {
            tableSql = (String[])dimList.get(i2);
            if (tableSql[1] == null) {
                sb.append(",").append(tableSql[0]);
            } else {
                sb.append(", (").append(tableSql[1]).append(") ").append(tableSql[0]);
            }
            if (i2 > 0) {
                join.append(" and ");
            }
            join.append(factTable).append(".").append(tableSql[3]).append("=").append(tableSql[0]).append(".").append(tableSql[2]);
            ++i2;
        }
        sb.append(" where ").append((CharSequence)join);
        this.def.sql = sb.toString();
    }

    @Override
    public Table createTable() throws SQLException, OlapException {
        String sql;
        String string = sql = this.def.sql == null ? this.def.name : this.def.sql;
        if (sql.toLowerCase().indexOf("select") < 0) {
            sql = "select * from " + sql;
        }
        long time = System.currentTimeMillis();
        ResultSet rs = this.manager.executeQuery(sql);
        logger.debug((Object)("execute sql cost " + (System.currentTimeMillis() - time) + " ms. sql is \n" + sql));
        this.table = new ResultSetTable(rs);
        if (this.ref > 1) {
            this.table = new MemoryTable(this.table);
        }
        return this.table;
    }
}

