/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.def;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.olap.LeafFeature;
import kd.bos.algo.olap.def.ConditionalExpressionDef;
import kd.bos.algo.olap.def.ExpressionDef;
import kd.bos.algo.olap.def.ScopedExpressionDef;
import org.jdom.Element;

public class MemberExpressionDef
implements Serializable {
    private static final long serialVersionUID = 1492068174680575608L;
    private String uniqueName;
    private ExpressionDef expressionDef;
    private LeafFeature leafFeature;
    private List<ScopedExpressionDef> scopedList;
    private List<ConditionalExpressionDef> conditionalList;

    public MemberExpressionDef(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public void setLeafFeature(String leafFeature) {
        this.leafFeature = LeafFeature.of(leafFeature);
    }

    public LeafFeature getLeafFeature() {
        return this.leafFeature;
    }

    public void setExpressionDef(ExpressionDef expressionDef) {
        this.expressionDef = expressionDef;
    }

    public ExpressionDef getExpressionDef() {
        return this.expressionDef;
    }

    public void addScopedExpression(ScopedExpressionDef se) {
        if (this.scopedList == null) {
            this.scopedList = new ArrayList<ScopedExpressionDef>();
        }
        this.scopedList.add(se);
    }

    public List<ScopedExpressionDef> getScopedExpressionList() {
        return this.scopedList;
    }

    public void addConditionalExpression(ConditionalExpressionDef ce) {
        if (this.conditionalList == null) {
            this.conditionalList = new ArrayList<ConditionalExpressionDef>();
        }
        this.conditionalList.add(ce);
    }

    public List<ConditionalExpressionDef> getConditionalExpressionList() {
        return this.conditionalList;
    }

    public Element export() {
        Element element = new Element("MemberExpression");
        element.setAttribute("uniqueName", this.uniqueName);
        if (this.expressionDef != null) {
            element.addContent(this.expressionDef.export());
        }
        if (this.scopedList != null) {
            for (ScopedExpressionDef scopedExpressionDef : this.scopedList) {
                element.addContent(scopedExpressionDef.export());
            }
        }
        if (this.conditionalList != null) {
            for (ConditionalExpressionDef conditionalExpressionDef : this.conditionalList) {
                element.addContent(conditionalExpressionDef.export());
            }
        }
        return element;
    }
}

