/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.def;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.def.ConnectionDef;
import kd.bos.algo.olap.def.CubeDef;
import kd.bos.algo.olap.def.ParameterDef;
import kd.bos.algo.olap.def.PartitionDef;
import kd.bos.algo.olap.def.RelationDef;
import kd.bos.algo.olap.def.SchemaChecker;
import kd.bos.algo.olap.def.SharedDimensionDef;
import kd.bos.algo.olap.def.TableDef;
import org.jdom.Document;
import org.jdom.Element;

public class SchemaDef
implements Serializable {
    public String name;
    public String caption;
    public String description;
    public Properties config = new Properties();
    public ParameterDef[] parameters;
    public ConnectionDef connection;
    public TableDef[] tables;
    public SharedDimensionDef[] dimensions;
    public CubeDef[] cubes;
    public RelationDef[] relations;
    public PartitionDef partition;

    public void check() throws OlapException {
        new SchemaChecker(this).check();
    }

    public Document export() {
        return new Document(this.exportSchema());
    }

    public SharedDimensionDef getDimensionDef(String name) {
        int i = 0;
        while (i < this.dimensions.length) {
            if (this.dimensions[i].name.equalsIgnoreCase(name)) {
                return this.dimensions[i];
            }
            ++i;
        }
        return null;
    }

    Element exportConfig() {
        Element x = new Element("Config");
        Enumeration<?> e = this.config.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = this.config.getProperty(name);
            Element item = new Element("Item");
            item.setAttribute("name", name);
            item.setAttribute("value", value);
            x.addContent(item);
        }
        return x;
    }

    Element exportSchema() {
        int i;
        Element x = new Element("Schema");
        if (this.name != null) {
            x.setAttribute("name", this.name);
        }
        if (this.caption != null) {
            x.setAttribute("caption", this.caption);
        }
        if (this.description != null) {
            x.setAttribute("description", this.description);
        }
        if (this.config.size() > 0) {
            x.addContent(this.exportConfig());
        }
        if (this.parameters != null) {
            i = 0;
            while (i < this.parameters.length) {
                x.addContent(this.parameters[i].export());
                ++i;
            }
        }
        if (this.connection != null) {
            x.addContent(this.connection.export());
        }
        if (this.tables != null) {
            i = 0;
            while (i < this.tables.length) {
                x.addContent(this.tables[i].export());
                ++i;
            }
        }
        if (this.dimensions != null) {
            i = 0;
            while (i < this.dimensions.length) {
                x.addContent(this.dimensions[i].export());
                ++i;
            }
        }
        if (this.relations != null) {
            i = 0;
            while (i < this.relations.length) {
                x.addContent(this.relations[i].export());
                ++i;
            }
        }
        if (this.cubes != null) {
            i = 0;
            while (i < this.cubes.length) {
                x.addContent(this.cubes[i].export());
                ++i;
            }
        }
        return x;
    }

    public String toString() {
        return "[Schema '" + this.name + "']";
    }

    public TableDef getTableDef(String name) {
        int i = 0;
        while (i < this.tables.length) {
            if (this.tables[i].name.equalsIgnoreCase(name)) {
                return this.tables[i];
            }
            ++i;
        }
        return null;
    }
}

