/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.def;

import java.io.IOException;
import java.io.InputStream;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.def.SchemaDef;
import kd.bos.algo.olap.def.SchemaParser;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class SchemaLoader {
    private static Logger logger = Logger.getLogger(SchemaLoader.class);

    public static SchemaDef load(InputStream in) throws OlapException {
        Document doc = null;
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(in);
        }
        catch (JDOMException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Bad schema document.", (Throwable)e);
            }
            throw new OlapException("Bad schema document.", e);
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Unable to open the schema input stream.", (Throwable)e);
            }
            throw new OlapException("Unable to open the schema input stream.", e);
        }
        return SchemaParser.parse(doc);
    }
}

