/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.def;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import kd.bos.algo.olap.LeafFeature;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.def.AbstractCubeDimensionDef;
import kd.bos.algo.olap.def.CalculatedMemberDef;
import kd.bos.algo.olap.def.CalculatedMemberPropertyDef;
import kd.bos.algo.olap.def.ConditionDef;
import kd.bos.algo.olap.def.ConditionalExpressionDef;
import kd.bos.algo.olap.def.ConnectionDef;
import kd.bos.algo.olap.def.CubeDef;
import kd.bos.algo.olap.def.DimensionMembersDef;
import kd.bos.algo.olap.def.DimensionUsageDef;
import kd.bos.algo.olap.def.ExpressionDef;
import kd.bos.algo.olap.def.HierarchyDef;
import kd.bos.algo.olap.def.LevelDef;
import kd.bos.algo.olap.def.MeasureDef;
import kd.bos.algo.olap.def.MeasurePropertyDef;
import kd.bos.algo.olap.def.MemberExpressionDef;
import kd.bos.algo.olap.def.MemberScopeDef;
import kd.bos.algo.olap.def.ParameterDef;
import kd.bos.algo.olap.def.PartitionDef;
import kd.bos.algo.olap.def.PermissionDef;
import kd.bos.algo.olap.def.PermissionItemDef;
import kd.bos.algo.olap.def.PropertyDef;
import kd.bos.algo.olap.def.RelationDef;
import kd.bos.algo.olap.def.SchemaDef;
import kd.bos.algo.olap.def.ScopedExpressionDef;
import kd.bos.algo.olap.def.SharedDimensionDef;
import kd.bos.algo.olap.def.TableDef;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class SchemaParser {
    private static Logger log = Logger.getLogger(SchemaParser.class);

    public static SchemaDef parse(Document doc) throws OlapException {
        log.debug((Object)"Parsing Schema ...");
        Element x = doc.getRootElement();
        if (!x.getName().equals("Schema")) {
            throw new OlapException("Document is not a OLAP Schema.");
        }
        SchemaDef schemaDef = SchemaParser.parseSchema(x);
        log.debug((Object)"Parse succeeded.");
        return schemaDef;
    }

    private static SchemaDef parseSchema(Element x) throws OlapException {
        SchemaDef schema = new SchemaDef();
        schema.name = x.getAttributeValue("name");
        schema.caption = x.getAttributeValue("caption");
        schema.description = x.getAttributeValue("description");
        List items = x.getChildren();
        ArrayList<ParameterDef> params = new ArrayList<ParameterDef>();
        ArrayList<TableDef> tables = new ArrayList<TableDef>();
        ArrayList<SharedDimensionDef> dims = new ArrayList<SharedDimensionDef>();
        ArrayList<CubeDef> cubes = new ArrayList<CubeDef>();
        ArrayList<RelationDef> relations = new ArrayList<RelationDef>();
        HashSet<String> dimSet = new HashSet<String>(8);
        ConnectionDef conn = null;
        int i = 0;
        while (i < items.size()) {
            Element item = (Element)items.get(i);
            String itemName = item.getName();
            if (itemName.equals("Config")) {
                SchemaParser.parseConfig(schema.config, item);
            } else if (itemName.equals("Parameter")) {
                params.add(SchemaParser.parseParameter(item));
            } else if (itemName.equals("Connection")) {
                conn = SchemaParser.parseConnection(item);
            } else if (itemName.equals("Table")) {
                tables.add(SchemaParser.parseTable(item));
            } else if (itemName.equals("Dimension")) {
                dims.add(SchemaParser.parseShareDimension(dimSet, item));
            } else if (itemName.equals("Cube")) {
                cubes.add(SchemaParser.parseCube(item));
            } else if (itemName.equals("Relation")) {
                relations.add(SchemaParser.parseRelation(item));
            } else if (itemName.equals("Partition")) {
                schema.partition = SchemaParser.parsePartition(item);
            } else {
                throw new OlapException("Element type '" + itemName + "' not supported.");
            }
            ++i;
        }
        schema.parameters = new ParameterDef[params.size()];
        params.toArray(schema.parameters);
        schema.connection = conn;
        schema.tables = new TableDef[tables.size()];
        tables.toArray(schema.tables);
        schema.dimensions = new SharedDimensionDef[dims.size()];
        dims.toArray(schema.dimensions);
        schema.cubes = new CubeDef[cubes.size()];
        cubes.toArray(schema.cubes);
        schema.relations = new RelationDef[relations.size()];
        relations.toArray(schema.relations);
        return schema;
    }

    private static void parseConfig(Properties config, Element x) throws OlapException {
        List items = x.getChildren("Item");
        int i = 0;
        while (i < items.size()) {
            Element item = (Element)items.get(i);
            String name = item.getAttributeValue("name");
            String value = item.getAttributeValue("value");
            if (name == null || value == null) {
                throw new OlapException("Config item name or value undefined.");
            }
            config.setProperty(name, value);
            ++i;
        }
    }

    private static ParameterDef parseParameter(Element x) throws OlapException {
        ParameterDef param = new ParameterDef();
        param.name = x.getAttributeValue("name");
        param.type = x.getAttributeValue("type");
        return param;
    }

    private static RelationDef parseRelation(Element x) throws OlapException {
        RelationDef def = new RelationDef();
        def.name = x.getAttributeValue("name");
        def.dimensions = x.getAttributeValue("dimensions");
        return def;
    }

    private static PartitionDef parsePartition(Element x) throws OlapException {
        PartitionDef def = new PartitionDef();
        def.name = x.getAttributeValue("name");
        def.dimensions = x.getAttributeValue("dimensions");
        return def;
    }

    private static ConnectionDef parseConnection(Element x) throws OlapException {
        ConnectionDef cn = new ConnectionDef();
        cn.name = x.getAttributeValue("name");
        cn.driver = x.getAttributeValue("driver");
        cn.connectionString = x.getAttributeValue("connectionString");
        cn.user = x.getAttributeValue("user");
        cn.password = x.getAttributeValue("password");
        return cn;
    }

    private static TableDef parseTable(Element x) throws OlapException {
        TableDef table = new TableDef();
        table.name = x.getAttributeValue("name");
        table.sql = x.getAttributeValue("sql");
        return table;
    }

    private static SharedDimensionDef parseShareDimension(HashSet<String> dimSet, Element x) throws OlapException {
        SharedDimensionDef dim = new SharedDimensionDef();
        dim.name = x.getAttributeValue("name");
        if (!dimSet.add(dim.name)) {
            throw new OlapException("Duplicated dimension define: " + dim.name);
        }
        dim.caption = x.getAttributeValue("caption");
        dim.description = x.getAttributeValue("description");
        dim.type = x.getAttributeValue("type");
        dim.table = x.getAttributeValue("table");
        dim.sql = x.getAttributeValue("sql");
        dim.primaryKey = x.getAttributeValue("primaryKey");
        ArrayList<HierarchyDef> hies = new ArrayList<HierarchyDef>();
        List items = x.getChildren("Hierarchy");
        int i = 0;
        while (i < items.size()) {
            hies.add(SchemaParser.parseHierarchy((Element)items.get(i)));
            ++i;
        }
        dim.hierarchies = new HierarchyDef[hies.size()];
        hies.toArray(dim.hierarchies);
        Element element = x.getChild("Permission");
        if (element != null) {
            dim.permission = SchemaParser.parsePermission(dim.name, element);
        }
        return dim;
    }

    private static PermissionDef parsePermission(String parent, Element x) throws OlapException {
        PermissionDef per = new PermissionDef();
        per.type = x.getAttributeValue("type");
        ArrayList<Object> items = new ArrayList<Object>();
        List children = x.getChildren("Item");
        int i = 0;
        while (i < children.size()) {
            items.add(SchemaParser.parsePermissionItem((Element)children.get(i)));
            ++i;
        }
        per.items = new PermissionItemDef[children.size()];
        items.toArray(per.items);
        return per;
    }

    private static Object parsePermissionItem(Element x) {
        PermissionItemDef item = new PermissionItemDef();
        item.type = x.getAttributeValue("type");
        item.name = x.getAttributeValue("name");
        item.column = x.getAttributeValue("column");
        return item;
    }

    private static CubeDef parseCube(Element x) throws OlapException {
        CubeDef cube = new CubeDef();
        cube.name = x.getAttributeValue("name");
        cube.caption = x.getAttributeValue("caption");
        cube.description = x.getAttributeValue("description");
        cube.table = x.getAttributeValue("table");
        cube.measureDimensionCaption = x.getAttributeValue("measureDimensionCaption");
        ArrayList<MeasureDef> measures = new ArrayList<MeasureDef>();
        ArrayList<PropertyDef> properties = new ArrayList<PropertyDef>();
        ArrayList<CalculatedMemberDef> calculatedMembers = new ArrayList<CalculatedMemberDef>();
        ArrayList<MemberExpressionDef> memberExpressions = new ArrayList<MemberExpressionDef>();
        ArrayList<MemberScopeDef> memberScopes = new ArrayList<MemberScopeDef>();
        ArrayList<DimensionUsageDef> dims = new ArrayList<DimensionUsageDef>();
        List items = x.getChildren();
        int i = 0;
        while (i < items.size()) {
            Element item = (Element)items.get(i);
            String itemName = item.getName();
            if (itemName.equals("DimensionUsage")) {
                dims.add(SchemaParser.parseDimensionUsage(item));
            } else if (itemName.equals("Measure")) {
                measures.add(SchemaParser.parseMeasure(item));
            } else if (itemName.equals("Property")) {
                properties.add(SchemaParser.parseProperty(item));
            } else if (itemName.equals("CalculatedMember")) {
                calculatedMembers.add(SchemaParser.parseCalculatedMember(item));
            } else if (itemName.equals("MemberExpression")) {
                memberExpressions.add(SchemaParser.parseMemberExpression(item));
            } else if (itemName.equals("MemberScope")) {
                memberScopes.add(SchemaParser.parseMemberScope(item));
            } else {
                throw new OlapException("Unknown type '" + itemName + "' in cube '" + cube.name + "'");
            }
            ++i;
        }
        cube.dimensions = new AbstractCubeDimensionDef[dims.size()];
        dims.toArray(cube.dimensions);
        cube.measures = new MeasureDef[measures.size()];
        measures.toArray(cube.measures);
        cube.properties = new PropertyDef[properties.size()];
        properties.toArray(cube.properties);
        cube.calculatedMembers = new CalculatedMemberDef[calculatedMembers.size()];
        calculatedMembers.toArray(cube.calculatedMembers);
        cube.memberExpressions = memberExpressions.toArray(new MemberExpressionDef[memberExpressions.size()]);
        cube.memberScopes = memberScopes.toArray(new MemberScopeDef[memberScopes.size()]);
        return cube;
    }

    private static MemberScopeDef parseMemberScope(Element x) {
        String name = x.getAttributeValue("name");
        MemberScopeDef def = new MemberScopeDef(name);
        List children = x.getChildren("DimensionMembers");
        if (children == null || children.isEmpty()) {
            throw new OlapException("MemberScope require at least one DimensionMembers.");
        }
        for (Element e : children) {
            def.addItem(SchemaParser.parseDimensionMembers(e));
        }
        return def;
    }

    private static DimensionMembersDef parseDimensionMembers(Element e) {
        String dimension = e.getAttributeValue("dimension");
        Element child = e.getChild("Expression");
        if (child == null) {
            throw new OlapException("DimensionMembers require <Expression> element.");
        }
        String expression = child.getText();
        return new DimensionMembersDef(dimension, expression);
    }

    private static MemberExpressionDef parseMemberExpression(Element x) throws OlapException {
        List children;
        String s;
        MemberExpressionDef def = new MemberExpressionDef(x.getAttributeValue("uniqueName"));
        Element child = x.getChild("Expression");
        if (child != null) {
            ExpressionDef expressionDef = new ExpressionDef();
            expressionDef.text = child.getText();
            def.setExpressionDef(expressionDef);
        }
        if ((s = x.getAttributeValue("leafFeature")) != null) {
            def.setLeafFeature(s);
        }
        if ((children = x.getChildren("ConditionalExpression")) != null) {
            for (Element e : children) {
                def.addConditionalExpression(SchemaParser.parseConditionalExpression(e));
            }
        }
        if ((children = x.getChildren("ScopedExpression")) != null) {
            for (Element e : children) {
                def.addScopedExpression(SchemaParser.parseScopedExpression(e));
            }
        }
        return def;
    }

    private static ScopedExpressionDef parseScopedExpression(Element x) throws OlapException {
        String scope = x.getAttributeValue("scope");
        if (scope == null) {
            throw new OlapException("ScopedExpressionDef require scope.");
        }
        LeafFeature leafFeature = null;
        String s = x.getAttributeValue("leafFeature");
        if (s != null) {
            leafFeature = LeafFeature.of(s);
        }
        ExpressionDef expressionDef = new ExpressionDef();
        Element e = x.getChild("Expression");
        expressionDef.text = e.getText();
        ScopedExpressionDef def = new ScopedExpressionDef(scope, expressionDef);
        def.setLeafFeature(leafFeature);
        return def;
    }

    private static ConditionalExpressionDef parseConditionalExpression(Element x) throws OlapException {
        Element e = x.getChild("Condition");
        if (e == null) {
            throw new OlapException("ConditionalExpressionDef require <Condition>.");
        }
        ConditionDef conditionDef = new ConditionDef();
        conditionDef.text = e.getText();
        e = x.getChild("Expression");
        if (e == null) {
            throw new OlapException("ConditionalExpressionDef require <Expression>.");
        }
        ExpressionDef expressionDef = new ExpressionDef();
        expressionDef.text = e.getText();
        return new ConditionalExpressionDef(conditionDef, expressionDef);
    }

    private static CalculatedMemberDef parseCalculatedMember(Element x) {
        CalculatedMemberDef def = new CalculatedMemberDef();
        def.name = x.getAttributeValue("name");
        def.caption = x.getAttributeValue("caption");
        def.solveOrder = x.getAttributeValue("solveOrder");
        def.dimension = x.getAttributeValue("dimension");
        def.formula = x.getAttributeValue("formula");
        def.formatString = x.getAttributeValue("formatString");
        def.color = x.getAttributeValue("color");
        def.bgColor = x.getAttributeValue("bgColor");
        def.trend = x.getAttributeValue("trend");
        def.status = x.getAttributeValue("status");
        String visible = x.getAttributeValue("visible");
        def.visible = !"false".equalsIgnoreCase(visible);
        ArrayList<CalculatedMemberPropertyDef> v = new ArrayList<CalculatedMemberPropertyDef>();
        List items = x.getChildren("Property");
        int i = 0;
        while (i < items.size()) {
            v.add(SchemaParser.parseCalculatedMemberProperty((Element)items.get(i)));
            ++i;
        }
        def.properties = new CalculatedMemberPropertyDef[items.size()];
        v.toArray(def.properties);
        return def;
    }

    private static CalculatedMemberPropertyDef parseCalculatedMemberProperty(Element x) {
        CalculatedMemberPropertyDef def = new CalculatedMemberPropertyDef();
        def.name = x.getAttributeValue("name");
        def.value = x.getAttributeValue("value");
        return def;
    }

    private static MeasurePropertyDef parseMeasureProperty(Element x) {
        MeasurePropertyDef def = new MeasurePropertyDef();
        def.name = x.getAttributeValue("name");
        def.value = x.getAttributeValue("value");
        return def;
    }

    private static DimensionUsageDef parseDimensionUsage(Element x) throws OlapException {
        DimensionUsageDef dim = new DimensionUsageDef();
        dim.name = x.getAttributeValue("name");
        dim.foreignKey = x.getAttributeValue("foreignKey");
        return dim;
    }

    private static MeasureDef parseMeasure(Element x) throws OlapException {
        String v;
        MeasureDef measure = new MeasureDef();
        measure.name = x.getAttributeValue("name");
        measure.caption = x.getAttributeValue("caption");
        measure.description = x.getAttributeValue("description");
        measure.column = x.getAttributeValue("column");
        measure.aggregator = x.getAttributeValue("aggregator");
        measure.formatString = x.getAttributeValue("formatString");
        measure.bgColor = x.getAttributeValue("bgColor");
        measure.color = x.getAttributeValue("color");
        measure.trend = x.getAttributeValue("trend");
        measure.status = x.getAttributeValue("status");
        if ("".equals(measure.color)) {
            measure.color = null;
        }
        if ("".equals(measure.bgColor)) {
            measure.bgColor = null;
        }
        if ("".equals(measure.trend)) {
            measure.trend = null;
        }
        if ("".equals(measure.status)) {
            measure.status = null;
        }
        measure.visible = !"false".equalsIgnoreCase(v = x.getAttributeValue("visible"));
        Element element = x.getChild("Permission");
        if (element != null) {
            measure.permission = SchemaParser.parsePermission(measure.name, element);
        }
        ArrayList<MeasurePropertyDef> vector = new ArrayList<MeasurePropertyDef>();
        List items = x.getChildren("Property");
        int i = 0;
        while (i < items.size()) {
            vector.add(SchemaParser.parseMeasureProperty((Element)items.get(i)));
            ++i;
        }
        measure.properties = new MeasurePropertyDef[items.size()];
        vector.toArray(measure.properties);
        return measure;
    }

    private static HierarchyDef parseHierarchy(Element x) throws OlapException {
        String aggregate;
        HierarchyDef hie = new HierarchyDef();
        hie.hasAll = false;
        hie.name = x.getAttributeValue("name");
        hie.caption = x.getAttributeValue("caption");
        hie.description = x.getAttributeValue("description");
        String hasAll = x.getAttributeValue("hasAll");
        if (hasAll != null) {
            if (hasAll.equalsIgnoreCase("True")) {
                hie.hasAll = true;
            } else if (hasAll.equalsIgnoreCase("False")) {
                hie.hasAll = false;
            } else {
                throw new OlapException("Hiearchy hasAll property value must be 'true' or 'false'.");
            }
        }
        if ((aggregate = x.getAttributeValue("aggregate")) != null) {
            if (aggregate.equalsIgnoreCase("True")) {
                hie.aggregate = true;
            } else if (aggregate.equalsIgnoreCase("False")) {
                hie.aggregate = false;
            } else {
                throw new OlapException("Hiearchy aggregate property value must be 'true' or 'false'.");
            }
        }
        hie.allMemberName = x.getAttributeValue("allMemberName");
        hie.allMemberCaption = x.getAttributeValue("allMemberCaption");
        hie.v$AllMemberCaption = x.getAttributeValue("virtualAllMemberCaption");
        ArrayList<LevelDef> levels = new ArrayList<LevelDef>();
        List items = x.getChildren("Level");
        int i = 0;
        while (i < items.size()) {
            levels.add(SchemaParser.parseLevel((Element)items.get(i)));
            ++i;
        }
        hie.levels = new LevelDef[levels.size()];
        levels.toArray(hie.levels);
        return hie;
    }

    private static LevelDef parseLevel(Element x) throws OlapException {
        LevelDef level = new LevelDef();
        level.name = x.getAttributeValue("name");
        level.caption = x.getAttributeValue("caption");
        level.description = x.getAttributeValue("description");
        level.type = x.getAttributeValue("type");
        level.column = x.getAttributeValue("column");
        level.isDateTimeColumn = x.getAttributeValue("isDateTimeColumn");
        if (level.isDateTimeColumn == null) {
            level.isDateTimeColumn = "true";
        }
        level.orderBy = x.getAttributeValue("orderBy");
        level.orderMethod = x.getAttributeValue("orderMethod");
        level.childColumn = x.getAttributeValue("childColumn");
        level.parentColumn = x.getAttributeValue("parentColumn");
        level.dataType = x.getAttributeValue("dataType");
        level.closureDataType = x.getAttributeValue("closureDataType");
        level.rule = x.getAttributeValue("rule");
        String temp = x.getAttributeValue("maxDepth");
        if (temp != null) {
            level.maxDepth = Integer.parseInt(temp);
        }
        ArrayList<PropertyDef> props = new ArrayList<PropertyDef>();
        List items = x.getChildren("Property");
        int i = 0;
        while (i < items.size()) {
            props.add(SchemaParser.parseProperty((Element)items.get(i)));
            ++i;
        }
        level.properties = new PropertyDef[props.size()];
        props.toArray(level.properties);
        return level;
    }

    private static PropertyDef parseProperty(Element x) throws OlapException {
        PropertyDef prop = new PropertyDef();
        prop.name = x.getAttributeValue("name");
        prop.caption = x.getAttributeValue("caption");
        prop.description = x.getAttributeValue("description");
        prop.column = x.getAttributeValue("column");
        prop.dataType = x.getAttributeValue("dataType");
        return prop;
    }
}

