/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import kd.bos.algo.olap.Cube;
import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.impl.DimensionImpl;
import kd.bos.algo.olap.util.BBFilter;

public class BBFilterIndex {
    private int[] indexes;
    BBFilter filter;
    private int[] coords;

    public BBFilterIndex(Cube cube, Dimension ... dims) {
        int[] cards = new int[dims.length];
        this.indexes = new int[dims.length];
        int i = 0;
        while (i < dims.length) {
            this.indexes[i] = dims[i].getOrdinal(cube);
            cards[i] = ((DimensionImpl)dims[i]).getMemberCount();
            ++i;
        }
        this.filter = new BBFilter(cards);
        this.coords = new int[this.indexes.length];
    }

    public BBFilterIndex(int[] cards, int[] indexes) {
        this.indexes = indexes;
        this.filter = new BBFilter(cards);
        this.coords = new int[indexes.length];
    }

    public void add(Member ... members) {
        int i = 0;
        while (i < this.indexes.length) {
            this.coords[i] = members[this.indexes[i]].getGlobalOrder();
            ++i;
        }
        this.filter.set(this.coords);
    }

    public boolean get(Member[] members) {
        int i = 0;
        while (i < this.indexes.length) {
            this.coords[i] = members[this.indexes[i]].getGlobalOrder();
            ++i;
        }
        return this.filter.get(this.coords);
    }

    public void addRaw(Member ... members) {
        int i = 0;
        while (i < this.indexes.length) {
            this.coords[i] = members[i].getGlobalOrder();
            ++i;
        }
        this.filter.set(this.coords);
    }

    public boolean getRaw(Member[] members) {
        int i = 0;
        while (i < this.indexes.length) {
            this.coords[i] = members[i].getGlobalOrder();
            ++i;
        }
        return this.filter.get(this.coords);
    }
}

