/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.util.ArrayList;
import kd.bos.algo.olap.Cube;
import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.Relation;
import kd.bos.algo.olap.impl.BBFilterIndex;
import kd.bos.algo.olap.impl.DimensionImpl;

public class BBFilterIndexes {
    private static int RELATION_COUNT;
    private static int DIM_PER_RELATION;
    private BBFilterIndex[] indexes;

    static {
        String str = System.getProperty("OLAP_BBFILTER_RELATION_COUNT");
        if (str != null) {
            RELATION_COUNT = Integer.parseInt(str);
        }
        if ((str = System.getProperty("OLAP_BBFILTER_DIM_PER_RELATION")) != null) {
            DIM_PER_RELATION = Integer.parseInt(str);
        }
        RELATION_COUNT = 5;
        DIM_PER_RELATION = 3;
    }

    public BBFilterIndexes(BBFilterIndex[] indexes) {
        this.indexes = indexes;
    }

    public BBFilterIndexes(Cube cube) {
        Relation[] relations = cube.getSchema().getRelations();
        if (relations != null && relations.length > 0) {
            this.initByRelation(relations, cube);
        } else {
            this.defaultInit(cube);
        }
    }

    public void initByRelation(Relation[] relations, Cube cube) {
        ArrayList<BBFilterIndex> filterIndexList = new ArrayList<BBFilterIndex>();
        ArrayList<Integer> usedDimList = new ArrayList<Integer>();
        ArrayList<Integer> cardList = new ArrayList<Integer>();
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        long discards = 1L;
        Relation[] relationArray = relations;
        int n = relations.length;
        int n2 = 0;
        while (n2 < n) {
            Relation relation = relationArray[n2];
            discards = 1L;
            cardList.clear();
            indexList.clear();
            Dimension[] dims = relation.getDimensions();
            int i = 0;
            while (i < dims.length) {
                int card = ((DimensionImpl)dims[i]).getMemberCount();
                if (card >= 2) {
                    if ((discards *= (long)card) < 0L) break;
                    cardList.add(card);
                    indexList.add(i);
                    if (!usedDimList.contains(i)) {
                        usedDimList.add(i);
                    }
                }
                ++i;
            }
            int[] cards = new int[cardList.size()];
            int[] indexes = new int[indexList.size()];
            int i2 = 0;
            while (i2 < cards.length) {
                cards[i2] = (Integer)cardList.get(i2);
                indexes[i2] = (Integer)indexList.get(i2);
                ++i2;
            }
            BBFilterIndex filterIndex = new BBFilterIndex(cards, indexes);
            filterIndexList.add(filterIndex);
            ++n2;
        }
        this.indexes = filterIndexList.toArray(new BBFilterIndex[filterIndexList.size()]);
    }

    public void defaultInit(Cube cube) {
        this.defaultInit(cube, new ArrayList<BBFilterIndex>(), new ArrayList<Integer>());
    }

    public void defaultInit(Cube cube, ArrayList<BBFilterIndex> filterIndexList, ArrayList<Integer> usedDimList) {
        BBFilterIndex filterIndex;
        Dimension[] dims = cube.getDimensions();
        ArrayList<Integer> cardList = new ArrayList<Integer>();
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        long discards = 1L;
        int i = 0;
        while (i < dims.length) {
            int card;
            if (!dims[i].isTimeDimension() && !dims[i].isParentChildrenDimension() && dims[i].getDefaultHierarchy().getLevels().length == 1 && (card = ((DimensionImpl)dims[i]).getMemberCount()) >= 2) {
                if ((discards *= (long)card) < 0L) break;
                cardList.add(card);
                indexList.add(i);
                usedDimList.add(i);
                if (usedDimList.size() > 2) break;
            }
            ++i;
        }
        if (indexList.size() > 1) {
            int[] cards = new int[cardList.size()];
            int[] indexes = new int[indexList.size()];
            int i2 = 0;
            while (i2 < cards.length) {
                cards[i2] = (Integer)cardList.get(i2);
                indexes[i2] = (Integer)indexList.get(i2);
                ++i2;
            }
            filterIndex = new BBFilterIndex(cards, indexes);
            filterIndexList.add(filterIndex);
        } else {
            usedDimList.clear();
        }
        while (filterIndexList.size() < RELATION_COUNT) {
            discards = 1L;
            cardList.clear();
            indexList.clear();
            i = 0;
            while (i < dims.length) {
                int card;
                if (!usedDimList.contains(i) && (card = ((DimensionImpl)dims[i]).getMemberCount()) >= 2) {
                    if ((discards *= (long)card) < 0L) break;
                    cardList.add(card);
                    indexList.add(i);
                    usedDimList.add(i);
                    if (cardList.size() >= DIM_PER_RELATION) break;
                }
                ++i;
            }
            if (cardList.size() < 2) break;
            int[] cards = new int[cardList.size()];
            int[] indexes = new int[indexList.size()];
            int i3 = 0;
            while (i3 < cards.length) {
                cards[i3] = (Integer)cardList.get(i3);
                indexes[i3] = (Integer)indexList.get(i3);
                ++i3;
            }
            filterIndex = new BBFilterIndex(cards, indexes);
            filterIndexList.add(filterIndex);
        }
        this.indexes = filterIndexList.toArray(new BBFilterIndex[filterIndexList.size()]);
    }

    public void add(Member[] members) {
        BBFilterIndex[] bBFilterIndexArray = this.indexes;
        int n = this.indexes.length;
        int n2 = 0;
        while (n2 < n) {
            BBFilterIndex index = bBFilterIndexArray[n2];
            index.add(members);
            ++n2;
        }
    }

    public boolean inAll(Member[] members) {
        int i = 0;
        while (i < this.indexes.length) {
            if (!this.indexes[i].get(members)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean inOne(Member[] members) {
        int i = 0;
        while (i < this.indexes.length) {
            if (this.indexes[i].get(members)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

