/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.awt.Color;
import java.io.Serializable;
import java.math.BigDecimal;
import kd.bos.algo.olap.AvgValue;
import kd.bos.algo.olap.Cell;
import kd.bos.algo.olap.Formatter;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.util.ColorUtil;
import kd.bos.algo.olap.util.Util;

public class CellImpl
implements Cell,
Serializable {
    private static final long serialVersionUID = -5194489819006676574L;
    Object value;
    Formatter format;
    boolean isNull;
    Member[] memberContext;
    Member measure;

    public CellImpl(Member[] context, Member measure, Object _value, Formatter _format) {
        this.memberContext = context;
        this.measure = measure;
        if (_value instanceof AvgValue) {
            _value = ((AvgValue)_value).getAvgValue();
        }
        this.value = _value instanceof BigDecimal ? Util.internBigDecimal((BigDecimal)_value) : _value;
        this.format = _format;
    }

    public CellImpl(Member[] context) {
        this.memberContext = context;
        this.isNull = true;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getFormattedValue() {
        if (this.isNull) {
            return "";
        }
        if (this.format == null) {
            if (this.value == null) {
                return "";
            }
            return this.value.toString();
        }
        return this.format.format(this.value);
    }

    @Override
    public boolean isNull() {
        return this.isNull;
    }

    @Override
    public Member[] getMemberContext() {
        return this.memberContext;
    }

    public Member getMeasure() {
        return this.measure;
    }

    @Override
    public String getFormatString() {
        if (this.format == null) {
            return null;
        }
        return this.format.getFormatString();
    }

    @Override
    public Color getForeColor() {
        if (this.format == null) {
            return null;
        }
        if (this.format.getColor() != null) {
            return ColorUtil.getColor(this.format.getColor());
        }
        return null;
    }

    @Override
    public Color getBgColor() {
        if (this.format == null) {
            return null;
        }
        if (this.format.getBgColor() != null) {
            return ColorUtil.getColor(this.format.getBgColor());
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        int i = 0;
        while (i < this.memberContext.length) {
            sb.append(this.memberContext[i]).append(",");
            ++i;
        }
        sb.append(this.measure.getName());
        sb.append(")=").append(this.getFormattedValue());
        return sb.toString();
    }
}

