/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.util.HashMap;
import kd.bos.algo.olap.Connection;
import kd.bos.algo.olap.Database;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.impl.CellReaderImpl;
import kd.bos.algo.olap.impl.ConnectionImpl;
import kd.bos.algo.olap.impl.CubeImpl;
import kd.bos.algo.olap.impl.EvaluateContext;
import kd.bos.algo.olap.impl.EvaluatorImpl;
import kd.bos.algo.olap.impl.LinkCellReader;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.ParserHelp;
import kd.bos.algo.olap.mdx.SchemaReader;
import kd.bos.algo.olap.mdx.StackExpResolver;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.mdx.calc.impl.BetterScalarExpCompiler;

public class CubeEvaluateContext
implements EvaluateContext {
    private SchemaReader schemaReader;
    private BetterScalarExpCompiler compiler;
    private StackExpResolver resolver;
    private CubeImpl cube;
    private CellReaderImpl cellReader;
    private Database db;
    private HashMap<String, LinkCellReader> linkCellReaderMap;

    public CubeEvaluateContext(Database db) {
        this.db = db;
        this.schemaReader = db.getSchemaReader();
        this.cube = (CubeImpl)this.schemaReader.getCube();
        this.cellReader = new CellReaderImpl(db.getCubeDataReader(this.cube));
        this.resolver = new StackExpResolver(this.getSchemaReader());
        this.compiler = new BetterScalarExpCompiler(this.resolver);
    }

    @Override
    public SchemaReader getSchemaReader() {
        return this.schemaReader;
    }

    @Override
    public Calc getCellCalculation(Evaluator evaluator) throws OlapException {
        return null;
    }

    @Override
    public Exp parseExpression(String expression, boolean resolve) {
        Exp exp = ParserHelp.parseExpression(expression);
        return resolve ? this.resolver.resolve(exp) : exp;
    }

    @Override
    public Calc compileExpression(Exp exp, boolean scalar) throws OlapException {
        if (scalar) {
            return this.compiler.compileScalar(exp, false);
        }
        return exp.compile(this.compiler);
    }

    @Override
    public boolean hasFormulas() {
        return false;
    }

    @Override
    public Evaluator createEvaluator() {
        EvaluatorImpl evaluator = new EvaluatorImpl(this, this.cube, this.cellReader);
        evaluator.setContext(this.cube.getMeasures()[0]);
        return evaluator;
    }

    @Override
    public LinkCellReader getLinkCellReader(String linkName) {
        LinkCellReader lcr;
        Connection linkConnection = this.db.getConnection().getLink(linkName);
        if (this.linkCellReaderMap == null) {
            this.linkCellReaderMap = new HashMap();
        }
        if ((lcr = this.linkCellReaderMap.get(linkName)) == null) {
            lcr = new LinkCellReader((ConnectionImpl)linkConnection);
            this.linkCellReaderMap.put(linkName, lcr);
        }
        return lcr;
    }
}

