/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.dbsource.TableProvider;
import kd.bos.algo.olap.def.SchemaDef;
import kd.bos.algo.olap.def.SharedDimensionDef;
import kd.bos.algo.olap.impl.BuildContext;
import kd.bos.algo.olap.impl.DimensionBuildResult;
import kd.bos.algo.olap.impl.DimensionBuilderRunnable;
import kd.bos.algo.olap.impl.DimensionImpl;
import kd.bos.algo.olap.impl.OlapThreadPool;
import kd.bos.algo.olap.impl.SchemaImpl;
import kd.bos.algo.olap.impl.Stats;
import org.apache.log4j.Logger;

public class DimensionBuilder {
    private static Logger logger = Logger.getLogger(DimensionBuilder.class);

    public static void build(BuildContext buildContext, SchemaImpl schema, SchemaDef def, Stats stats) throws OlapException, SQLException {
        long begin = System.currentTimeMillis();
        if (OlapThreadPool.support()) {
            ConcurrentHashMap<String, Object> resultHandler = new ConcurrentHashMap<String, Object>();
            CountDownLatch latch = new CountDownLatch(def.dimensions.length);
            int i = 0;
            while (i < def.dimensions.length) {
                DimensionImpl dim = schema.dims[i];
                SharedDimensionDef dimDef = def.dimensions[i];
                TableProvider tableProvider = buildContext.getTableManager().getTableProvider(dimDef.table);
                DimensionBuilderRunnable runnable = new DimensionBuilderRunnable(tableProvider, dim, dimDef, resultHandler, latch, stats);
                OlapThreadPool.execute(runnable);
                ++i;
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new OlapException("Erorr when build dimensions.", e);
            }
            Throwable error = null;
            int i2 = 0;
            while (i2 < def.dimensions.length) {
                DimensionImpl dim = schema.dims[i2];
                SharedDimensionDef dimDef = def.dimensions[i2];
                buildContext.getTableManager().releaseTable(dimDef.table);
                Object result = resultHandler.get(dim.getName());
                if (result instanceof Throwable) {
                    error = (Throwable)result;
                } else {
                    buildContext.setDimensionResult(dim.getName(), (DimensionBuildResult)result);
                }
                ++i2;
            }
            if (error != null) {
                if (error instanceof OlapException) {
                    throw (OlapException)error;
                }
                throw new OlapException("Erorr when build dimensions.", error);
            }
        } else {
            int i = 0;
            while (i < def.dimensions.length) {
                DimensionImpl dim = schema.dims[i];
                SharedDimensionDef dimDef = def.dimensions[i];
                TableProvider tableProvider = buildContext.getTableManager().getTableProvider(dimDef.table);
                Stats.StatItem item = stats.createStatItem("build dimension:" + dim.getName());
                DimensionBuildResult result = DimensionBuilderRunnable.build(tableProvider, dim, dimDef, item);
                item.close();
                buildContext.getTableManager().releaseTable(dimDef.table);
                buildContext.setDimensionResult(dim.getName(), result);
                ++i;
            }
        }
        long cost = System.currentTimeMillis() - begin;
        logger.info((Object)("Build " + def.dimensions.length + " dimensions cost: " + cost + "ms."));
    }
}

