/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.dbsource.Table;
import kd.bos.algo.olap.dbsource.TableProvider;
import kd.bos.algo.olap.def.HierarchyDef;
import kd.bos.algo.olap.def.SharedDimensionDef;
import kd.bos.algo.olap.impl.DimensionBuildResult;
import kd.bos.algo.olap.impl.DimensionImpl;
import kd.bos.algo.olap.impl.HierarchyFetch;
import kd.bos.algo.olap.impl.HierarchyImpl;
import kd.bos.algo.olap.impl.Key;
import kd.bos.algo.olap.impl.MemberImpl;
import kd.bos.algo.olap.impl.Stats;
import org.apache.log4j.Logger;

public class DimensionBuilderRunnable
implements Runnable {
    private static Logger logger = Logger.getLogger(DimensionBuilderRunnable.class);
    private DimensionImpl dim;
    private SharedDimensionDef dimDef;
    private Map<String, Object> resultHolder;
    private CountDownLatch latch;
    private TableProvider tableProvider;
    private Stats stats;

    public DimensionBuilderRunnable(TableProvider tableProvider, DimensionImpl dim, SharedDimensionDef dimDef, Map<String, Object> resultHolder, CountDownLatch latch, Stats stats) {
        this.tableProvider = tableProvider;
        this.dim = dim;
        this.dimDef = dimDef;
        this.resultHolder = resultHolder;
        this.latch = latch;
        this.stats = stats;
    }

    @Override
    public void run() {
        block6: {
            Stats.StatItem item = this.stats.createStatItem("build dimension:" + this.dim.getName());
            try {
                try {
                    DimensionBuildResult result = DimensionBuilderRunnable.build(this.tableProvider, this.dim, this.dimDef, item);
                    this.resultHolder.put(this.dim.name, result);
                }
                catch (Exception e2) {
                    OlapException e2;
                    if (!(e2 instanceof OlapException)) {
                        e2 = new OlapException(e2);
                    }
                    this.resultHolder.put(this.dim.name, e2);
                    item.close();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                item.close();
                throw throwable;
            }
            item.close();
        }
        this.latch.countDown();
    }

    public static DimensionBuildResult build(TableProvider tableProvider, DimensionImpl dim, SharedDimensionDef dimDef, Stats.StatItem item) throws OlapException, SQLException {
        logger.debug((Object)("building shared dimension '" + dimDef.name + "'..."));
        int errorRows = 0;
        Table table = null;
        try {
            long begin = System.currentTimeMillis();
            table = tableProvider.get();
            long costOfInput = System.currentTimeMillis() - begin;
            int hc = dimDef.hierarchies.length;
            HierarchyFetch[] hfs = new HierarchyFetch[hc];
            Key primaryKey = new Key(table, dimDef.primaryKey);
            DimensionBuildResult dbr = new DimensionBuildResult(dim);
            int i = 0;
            while (i < hc) {
                HierarchyDef hieDef = dimDef.hierarchies[i];
                HierarchyImpl hie = dim.hies[i];
                hfs[i] = new HierarchyFetch(hieDef, hie);
                ++i;
            }
            int rowCount = 0;
            begin = System.currentTimeMillis();
            long nextCost = 0L;
            block4: while (true) {
                long nextBegin = System.currentTimeMillis();
                boolean hasNext = table.next();
                nextCost += System.currentTimeMillis() - nextBegin;
                if (!hasNext) break;
                ++rowCount;
                int i2 = 0;
                while (true) {
                    if (i2 >= hc) continue block4;
                    MemberImpl member = hfs[i2].fetch(table);
                    Object key = primaryKey.getCurrentValue();
                    if (member == null || key == null) {
                        ++errorRows;
                    } else {
                        dbr.getHierarchyBuildResult().put(key, member);
                    }
                    ++i2;
                }
                break;
            }
            long costOfIterate = System.currentTimeMillis() - begin;
            begin = System.currentTimeMillis();
            int globalOrder = 0;
            int i3 = 0;
            while (i3 < hc) {
                hfs[i3].globalOrder = globalOrder;
                hfs[i3].finish();
                globalOrder = hfs[i3].globalOrder;
                ++i3;
            }
            dim.memberCount = globalOrder;
            long costOfFinish = System.currentTimeMillis() - begin;
            item.append("Cost[input,iterate(next),finish]=[" + costOfInput + "," + costOfIterate + "(" + nextCost + ")," + costOfFinish + "],[rows,members]=[" + rowCount + "," + dim.memberCount + "]");
            logger.debug((Object)("building dimension member size '" + dim.memberCount + "'..."));
            if (errorRows > 0) {
                logger.info((Object)("Found " + errorRows + " error rows when building shared dimension '" + dimDef.name + "'..."));
                item.append("error rows:" + errorRows);
            }
            DimensionBuildResult dimensionBuildResult = dbr;
            return dimensionBuildResult;
        }
        finally {
            if (table != null) {
                table.close();
            }
        }
    }
}

