/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.algo.olap.Cube;
import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Engine;
import kd.bos.algo.olap.Hierarchy;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.MemberScope;
import kd.bos.algo.olap.OlapElement;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.impl.BBFilterIndex;
import kd.bos.algo.olap.impl.BBFilterIndexes;
import kd.bos.algo.olap.impl.CubeElementBase;
import kd.bos.algo.olap.impl.HierarchyImpl;
import kd.bos.algo.olap.impl.MemberImpl;
import kd.bos.algo.olap.impl.MemberScopeImpl;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.SchemaReader;
import kd.bos.algo.olap.mdx.type.DimensionType;
import kd.bos.algo.olap.mdx.type.Type;
import kd.bos.algo.olap.util.UniqueNameUtil;

public class DimensionImpl
extends CubeElementBase
implements Dimension {
    public static final long serialVersionUID = 456721298477547547L;
    HierarchyImpl[] hies;
    byte dimensionType = 0;
    int memberCount;
    Map<Integer, Member> mapOrderToMember = new HashMap<Integer, Member>();
    boolean isParentChildren = false;
    private boolean hasWeight;
    private boolean hasDisableAgg;
    private HashSet<MemberImpl> calcMembersOfAll = new HashSet(1);
    private HashSet<MemberImpl> calcMembersOfLeaf = new HashSet(1);
    private HashSet<MemberImpl> calcMembersOfNotLeaf = new HashSet(1);
    private int ordinal = -1;
    private transient String uniqueName;
    private HashMap<String, Member> memberCache = null;

    @Override
    public Hierarchy[] getHierarchies() {
        return this.hies;
    }

    @Override
    public Hierarchy getHierarchy(String name) {
        return this.hies[0];
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, String name) throws OlapException {
        return this.getDefaultHierarchy().lookupChild(schemaReader, name);
    }

    @Override
    public Hierarchy getDefaultHierarchy() {
        return this.hies[0];
    }

    @Override
    public byte getDimensionType() {
        return this.dimensionType;
    }

    @Override
    public int getOrdinal(Cube cube) throws OlapException {
        return this.ordinal > 0 ? this.ordinal : (this.ordinal = cube.getDimensionOrdinal(this.name));
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public Iterator<Member> memberIterator() {
        return this.mapOrderToMember.values().iterator();
    }

    public Type getExpType() {
        return new DimensionType(this);
    }

    public int getCategory() {
        return 2;
    }

    @Override
    public String getUniqueName() {
        if (this.uniqueName == null) {
            this.uniqueName = UniqueNameUtil.makeUniqueName(this.getName());
        }
        return this.uniqueName;
    }

    @Override
    public boolean isMeasureDimension() {
        return this.dimensionType == -1;
    }

    @Override
    public boolean isTimeDimension() {
        return this.dimensionType == 1;
    }

    @Override
    public Hierarchy getHierarchy() {
        return this.getDefaultHierarchy();
    }

    @Override
    public Dimension getDimension() {
        return this;
    }

    @Override
    public String getCaption() {
        if (this.caption != null) {
            return this.caption;
        }
        if (this.isMeasureDimension()) {
            return Engine.getResource(Locale.getDefault(), "measureDimensionCaption");
        }
        return super.getCaption();
    }

    @Override
    public boolean isParentChildrenDimension() {
        return this.isParentChildren;
    }

    @Override
    public Dimension getDependOnDimension() {
        return (Dimension)this.getProperty("dependOnDimension");
    }

    @Override
    public boolean hasWeight() {
        return this.hasWeight;
    }

    @Override
    public void setHasWeight(boolean b) {
        this.hasWeight = b;
    }

    @Override
    public boolean hasDisableAgg() {
        return this.hasDisableAgg;
    }

    @Override
    public void setHasDisableAgg(boolean hasDisableAgg) {
        this.hasDisableAgg = hasDisableAgg;
    }

    public Member getMemberByName(String memberName) {
        if (this.memberCache == null) {
            this.initMemberCache();
        }
        return this.memberCache.get(memberName);
    }

    private void initMemberCache() {
        HashMap<String, Member> map = new HashMap<String, Member>();
        for (Member member : this.mapOrderToMember.values()) {
            map.put(member.getName(), member);
        }
        this.memberCache = map;
    }

    public void putCalcMemberOfAll(MemberImpl member) {
        this.calcMembersOfAll.add(member);
    }

    public void putCalcMemberOfLeaf(MemberImpl member) {
        this.calcMembersOfLeaf.add(member);
    }

    public void putCalcMemberOfNotLeaf(MemberImpl member) {
        this.calcMembersOfNotLeaf.add(member);
    }

    public boolean hasCalcMembers() {
        return this.calcMembersOfAll.size() > 0 || this.calcMembersOfLeaf.size() > 0 || this.calcMembersOfNotLeaf.size() > 0;
    }

    @Override
    public BBFilterIndexes buildScopeIndexes(Evaluator evaluator) {
        BBFilterIndexBuilder bbbuilder = new BBFilterIndexBuilder();
        HashSet<MemberScope> duplicated = new HashSet<MemberScope>();
        for (MemberImpl member : this.calcMembersOfAll) {
            this.buildMemberScope0(bbbuilder, evaluator, member, duplicated);
        }
        for (MemberImpl member : this.calcMembersOfLeaf) {
            this.buildMemberScope0(bbbuilder, evaluator, member, duplicated);
        }
        for (MemberImpl member : this.calcMembersOfNotLeaf) {
            this.buildMemberScope0(bbbuilder, evaluator, member, duplicated);
        }
        return bbbuilder.buildBBFilterIndexes();
    }

    private void buildMemberScope0(BBFilterIndexBuilder bbbuilder, Evaluator evaluator, MemberImpl member, HashSet<MemberScope> duplicated) {
        List<MemberScopeImpl> list = member.getMemberScopes();
        if (list != null) {
            for (MemberScopeImpl scope : list) {
                if (!duplicated.add(scope)) continue;
                this.buildScope(scope, evaluator, bbbuilder, member);
            }
        }
        if (member.getExpression(false) != null) {
            this.buildDefault(evaluator, bbbuilder, member);
        }
    }

    private void buildDefault(Evaluator evaluator, BBFilterIndexBuilder bbbuilder, MemberImpl member) {
        Dimension dim = member.getDimension();
        BBFilterIndex index = bbbuilder.get(evaluator.getCube(), dim);
        this.buildBB(index, member);
    }

    private void buildScope(MemberScopeImpl scope, Evaluator evaluator, BBFilterIndexBuilder bbbuilder, MemberImpl member) {
        scope.build(evaluator);
        Dimension dim = member.getDimension();
        DimensionImpl[] dims = scope.getDims();
        HashSet<Member>[] dimMembers = scope.getDimMembers();
        int i = 0;
        while (i < dims.length) {
            BBFilterIndex index = bbbuilder.get(evaluator.getCube(), dim, dims[i]);
            for (Member m : dimMembers[i]) {
                this.buildBB(index, member, m);
            }
            ++i;
        }
    }

    private void buildBB(BBFilterIndex index, Member ... members) {
        if (index.getRaw(members)) {
            return;
        }
        index.addRaw(members);
        Member[] members2 = null;
        int i = 0;
        while (i < members.length) {
            Member parent = members[i].getParentMember();
            if (parent != null) {
                members2 = new Member[members.length];
                System.arraycopy(members, 0, members2, 0, members.length);
                members2[i] = parent;
                this.buildBB(index, members2);
            }
            ++i;
        }
    }

    class BBFilterIndexBuilder {
        HashMap<String, BBFilterIndex> map = new HashMap();

        BBFilterIndexBuilder() {
        }

        public BBFilterIndex get(Cube cube, Dimension ... dims) {
            StringBuilder sb = new StringBuilder();
            Dimension[] dimensionArray = dims;
            int n = dims.length;
            int n2 = 0;
            while (n2 < n) {
                Dimension dim = dimensionArray[n2];
                sb.append(String.valueOf(dim.getName()) + ",");
                ++n2;
            }
            String key = sb.toString();
            BBFilterIndex index = this.map.get(key);
            if (index == null) {
                index = new BBFilterIndex(cube, dims);
                this.map.put(key, index);
            }
            return index;
        }

        public BBFilterIndexes buildBBFilterIndexes() {
            BBFilterIndex[] indexes = new BBFilterIndex[this.map.size()];
            int i = 0;
            for (BBFilterIndex index : this.map.values()) {
                indexes[i++] = index;
            }
            return new BBFilterIndexes(indexes);
        }
    }
}

