/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.olap.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.olap.CalculatedMember;
import kd.bos.algo.olap.Cube;
import kd.bos.algo.olap.Dimension;
import kd.bos.algo.olap.Hierarchy;
import kd.bos.algo.olap.Member;
import kd.bos.algo.olap.OlapException;
import kd.bos.algo.olap.exception.HierarchyNoMemberException;
import kd.bos.algo.olap.impl.Coordy;
import kd.bos.algo.olap.impl.EvaluateContext;
import kd.bos.algo.olap.impl.Point2;
import kd.bos.algo.olap.mdx.CellReader;
import kd.bos.algo.olap.mdx.Evaluator;
import kd.bos.algo.olap.mdx.Exp;
import kd.bos.algo.olap.mdx.SchemaReader;
import kd.bos.algo.olap.mdx.calc.Calc;
import kd.bos.algo.olap.util.BBFilter;
import kd.bos.algo.olap.util.Util;

public class EvaluatorImpl
implements Evaluator {
    private static Object NULL = new Object();
    protected final Cube cube;
    protected Member[] currentMembers;
    protected Member currentMeasure;
    protected final Evaluator parent;
    protected CellReader cellReader;
    protected final int depth;
    private final Map<Object, Object> expResultCache;
    private final Map<Point2, Object> cellCalculationCache;
    private BBFilter cellCalculationNullFilter;
    private final Coordy coordy;
    private Member expandingMember;
    private boolean nonEmpty;
    private boolean nonFactEmpty;
    private int currentMemberLength;
    private Map<Dimension, Integer> dimensionOrdinal;
    private Member[] slicerMember;
    protected EvaluateContext context;
    private HashMap<Object, Object> recurseCheckSet = new HashMap();

    private EvaluatorImpl(EvaluateContext context, Cube cube, CellReader cellReader, Evaluator parent, int depth, Map<Object, Object> expResultCache, Map<Point2, Object> cellCalculationCache) {
        this.context = context;
        this.cube = cube;
        this.cellReader = cellReader;
        this.parent = parent;
        this.depth = depth;
        this.expResultCache = expResultCache;
        this.cellCalculationCache = cellCalculationCache;
        this.coordy = new Coordy(cube.getDimensions(true));
        this.cellCalculationNullFilter = new BBFilter(this.coordy.getCards());
    }

    public EvaluatorImpl(EvaluateContext context, Cube cube, CellReader cellReader) throws OlapException {
        this(context, cube, cellReader, null, 0, new HashMap<Object, Object>(3, 2.0f), new HashMap<Point2, Object>());
        SchemaReader scr = context.getSchemaReader();
        Dimension[] dimensions = cube.getDimensions();
        this.currentMembers = new Member[dimensions.length];
        this.dimensionOrdinal = new HashMap<Dimension, Integer>(dimensions.length);
        int i = 0;
        while (i < dimensions.length) {
            Dimension dimension = dimensions[i];
            int ordinal = dimension.getOrdinal(cube);
            this.dimensionOrdinal.put(dimension, ordinal);
            Hierarchy hier = dimension.getDefaultHierarchy();
            Member member = scr.getHierarchyDefaultMember(hier);
            if (member == null) {
                throw new HierarchyNoMemberException(hier);
            }
            this.currentMembers[ordinal] = member;
            ++i;
        }
        this.currentMemberLength = this.currentMembers.length;
    }

    protected EvaluatorImpl(EvaluateContext context, Cube cube, Member[] currentMembers, EvaluatorImpl parent) {
        this(context, cube, parent.cellReader, parent, parent.depth + 1, parent.expResultCache, parent.cellCalculationCache);
        this.currentMembers = currentMembers;
        this.dimensionOrdinal = parent.dimensionOrdinal;
        this.currentMemberLength = parent.currentMemberLength;
        this.slicerMember = parent.slicerMember;
        this.currentMeasure = parent.currentMeasure;
        this.recurseCheckSet = parent.recurseCheckSet;
    }

    public Map<Object, Object> getRecurseChecker() {
        return this.recurseCheckSet;
    }

    @Override
    public EvaluateContext getContext() {
        return this.context;
    }

    @Override
    public Cube getCube() {
        return this.cube;
    }

    public Map<Point2, Object> getCellCalculationCache() {
        return this.cellCalculationCache;
    }

    public BBFilter getCellCalculationNullFilter() {
        return this.cellCalculationNullFilter;
    }

    @Override
    public Evaluator push(Member[] members) throws OlapException {
        Evaluator evaluator = this.push();
        evaluator.setContext(members);
        return evaluator;
    }

    @Override
    public Evaluator push() {
        Member[] cloneCurrentMembers = (Member[])this.currentMembers.clone();
        EvaluatorImpl evaluator = new EvaluatorImpl(this.context, this.cube, cloneCurrentMembers, this);
        return evaluator;
    }

    @Override
    public Evaluator push(Member member) throws OlapException {
        Evaluator evaluator = this.push();
        evaluator.setContext(member);
        return evaluator;
    }

    @Override
    public Evaluator pop() {
        return this.parent;
    }

    @Override
    public Member setContext(Member member) throws OlapException {
        Member previous;
        Member m = member;
        if (m.isMeasure()) {
            previous = this.currentMeasure;
            this.currentMeasure = member;
        } else {
            int ordinal = member.getDimension().getOrdinal(this.cube);
            previous = this.currentMembers[ordinal];
            this.currentMembers[ordinal] = m;
        }
        return previous;
    }

    @Override
    public void setContext(Member[] members) throws OlapException {
        this.setContextAsObject(members);
    }

    private void setContextAsObject(Object[] members) throws OlapException {
        int i = 0;
        while (i < members.length) {
            Member member = (Member)members[i];
            if (member != null) {
                this.setContext(member);
            }
            ++i;
        }
    }

    @Override
    public Member getContext(Dimension dimension) throws OlapException {
        if (dimension.isMeasureDimension()) {
            return this.currentMeasure;
        }
        int ordinal = dimension.getOrdinal(this.cube);
        return this.currentMembers[ordinal];
    }

    @Override
    public Object evaluateCurrent() throws OlapException {
        Calc cellCalculation = this.context.getCellCalculation(this);
        if (cellCalculation != null) {
            Point2 point = new Point2(this.coordy, this.currentMembers, this.currentMeasure);
            long coord = point.getCoordinate();
            if (coord > 0L && this.cellCalculationNullFilter.get(coord)) {
                return null;
            }
            Object o = this.cellCalculationCache.get(point);
            if (o == null) {
                o = cellCalculation.evaluate(this);
                if (o == null) {
                    if (coord > 0L) {
                        this.cellCalculationNullFilter.set(coord);
                    } else {
                        this.cellCalculationCache.put(point, NULL);
                    }
                } else {
                    this.cellCalculationCache.put(point, o);
                }
                return o;
            }
            if (o == NULL) {
                return null;
            }
            return o;
        }
        Member maxSolveMember = this.getMaxSolveMember();
        if (maxSolveMember != null) {
            Member defaultMember = maxSolveMember.getHierarchy().getDefaultMember();
            EvaluatorImpl evaluator = (EvaluatorImpl)this.push(defaultMember);
            evaluator.setExpanding(maxSolveMember);
            Object o = null;
            Exp exp = null;
            CalculatedMember cMember = (CalculatedMember)maxSolveMember;
            if (cMember.isNull()) {
                o = null;
            } else {
                exp = cMember.getExpression(true);
                Calc calc = this.context.compileExpression(exp, true);
                o = calc.evaluate(evaluator);
            }
            if (o == Util.nullValue) {
                return null;
            }
            return o;
        }
        return this.cellReader.get(this);
    }

    private void setExpanding(Member member) throws OlapException {
        this.expandingMember = member;
        int memberCount = this.currentMembers.length;
        if (this.depth > memberCount && this.depth % memberCount == 0) {
            EvaluatorImpl.checkRecursion((EvaluatorImpl)this.parent);
        }
    }

    private static void checkRecursion(EvaluatorImpl eval) throws OlapException {
        while (true) {
            if (eval == null) {
                return;
            }
            if (eval.expandingMember != null) break;
            eval = (EvaluatorImpl)eval.getParent();
        }
        EvaluatorImpl eval2 = (EvaluatorImpl)eval.getParent();
        while (eval2 != null) {
            block6: {
                if (eval2.expandingMember == eval.expandingMember) {
                    int i = 0;
                    while (i < eval.currentMembers.length) {
                        Member parentMember;
                        Member member = eval2.currentMembers[i];
                        if (member == null || member == (parentMember = eval.getContext(member.getDimension()))) {
                            ++i;
                            continue;
                        }
                        break block6;
                    }
                    throw new OlapException("Infinite loop while evaluating calculated member '" + eval.expandingMember + "'; context stack is " + eval.getContextString());
                }
            }
            eval2 = (EvaluatorImpl)eval2.getParent();
        }
    }

    private String getContextString() {
        boolean skipDefaultMembers = true;
        StringBuilder sb = new StringBuilder("{");
        int frameCount = 0;
        EvaluatorImpl eval = this;
        while (eval != null) {
            if (eval.expandingMember != null) {
                if (frameCount++ > 0) {
                    sb.append(", ");
                }
                sb.append("(");
                int memberCount = 0;
                int j = 0;
                while (j < eval.currentMembers.length) {
                    Member m = eval.currentMembers[j];
                    if (!skipDefaultMembers || m != m.getHierarchy().getDefaultMember()) {
                        if (memberCount++ > 0) {
                            sb.append(", ");
                        }
                        sb.append(m.getUniqueName());
                    }
                    ++j;
                }
                sb.append(", ").append(this.currentMeasure.getUniqueName());
                sb.append(")");
            }
            eval = (EvaluatorImpl)eval.getParent();
        }
        sb.append("}");
        return sb.toString();
    }

    public Member getMaxSolveMember() throws OlapException {
        int maxSolve = Integer.MIN_VALUE;
        Member maxSolveMember = null;
        int i = -1;
        int count = this.currentMembers.length;
        while (i < count) {
            int solve;
            Member currentMember = i == -1 ? this.currentMeasure : this.currentMembers[i];
            if (currentMember != null && currentMember.isCalculated() && (solve = ((CalculatedMember)currentMember).getSolveOrder()) > maxSolve) {
                maxSolve = solve;
                maxSolveMember = currentMember;
            }
            ++i;
        }
        return maxSolveMember;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public Evaluator getParent() {
        return this.parent;
    }

    @Override
    public SchemaReader getSchemaReader() {
        return this.context.getSchemaReader();
    }

    private Object getExpResultCacheKey(Exp exp) {
        ArrayList<Serializable> key = new ArrayList<Serializable>();
        key.add(exp);
        int i = 0;
        while (i < this.currentMembers.length) {
            Dimension dim;
            Member member = this.currentMembers[i];
            if (member != null && exp.dependsOn(dim = member.getDimension())) {
                key.add(this.currentMembers[i]);
            }
            ++i;
        }
        return key;
    }

    @Override
    public Object getCachedResult(Exp exp) {
        Object key = this.getExpResultCacheKey(exp);
        return this.expResultCache.get(key);
    }

    @Override
    public void setCachedResult(Exp exp, Object result) {
        Object key = this.getExpResultCacheKey(exp);
        this.expResultCache.put(key, result);
    }

    public void clearExpResultCache(boolean clearFact) {
        this.expResultCache.clear();
    }

    @Override
    public boolean isNonEmpty() {
        return this.nonEmpty;
    }

    @Override
    public void setNonEmpty(boolean b) {
        this.nonEmpty = b;
    }

    @Override
    public boolean isNonFactEmpty() {
        return this.nonFactEmpty;
    }

    @Override
    public void setNonFactEmpty(boolean nonFactEmpty) {
        this.nonFactEmpty = nonFactEmpty;
    }

    @Override
    public Member[] getCurrentMembers() {
        return this.currentMembers;
    }

    @Override
    public Member getCurrentMeasure() {
        return this.currentMeasure;
    }

    @Override
    public Member[] getSlicerMember() {
        return this.slicerMember;
    }

    public void setSlicerMember(Member[] slicerMember) {
        this.slicerMember = slicerMember;
    }

    public CellReader getCellReader() {
        return this.cellReader;
    }

    @Override
    public void setContext(Object o) throws OlapException {
        if (o instanceof Member) {
            this.setContext((Member)o);
        } else if (o instanceof Object[]) {
            this.setContextAsObject((Member[])o);
        } else {
            throw Util.newInternal("can't go here");
        }
    }
}

